/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class ColorChangerItem
extends Item {
    private static final List<String> CYCLING_BASES = List.of("zoea_blockz_0", "zoea_blockz_1", "zoea_blockz_2", "zoea_blockz_3");
    private static final Set<String> ALLOWED_FAMILIES = new HashSet<String>();
    private static final String[] COLOR_ORDER;

    public ColorChangerItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos startPos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        boolean reverse = player != null && player.isShiftKeyDown();
        int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
        Block clickedBlock = level.getBlockState(startPos).getBlock();
        this.applyMode(level, startPos, clickedBlock, this.extractFamilyKey(clickedBlock), mode, context.getClickedFace(), pos -> {
            Block blockAtPos = level.getBlockState(pos).getBlock();
            Block changedTo = this.resolveNextBlock(blockAtPos, reverse);
            if (changedTo != null) {
                BlockState newState = this.preserveRotation(level, (BlockPos)pos, changedTo);
                level.setBlock(pos, newState, 3);
                if (player != null && level.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)("\u2192  " + changedTo.getName().getString())), true);
                }
            }
        }, player);
        if (!level.isClientSide) {
            level.playSound(null, startPos, (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.BLOCKS, 1.0f, 1.5f);
        }
        return InteractionResult.SUCCESS;
    }

    private Block resolveNextBlock(Block current, boolean reverse) {
        String key = current.getDescriptionId();
        if (!key.contains("block.betterblockz.")) {
            return null;
        }
        String innerName = key.split("block\\.betterblockz\\.")[1];
        for (String base : CYCLING_BASES) {
            if (!innerName.equals(base)) continue;
            return this.cycleFromBase(base, reverse);
        }
        if (!innerName.contains("_blockz_")) {
            return null;
        }
        try {
            Block colorResult;
            String[] parts = innerName.split("_blockz_");
            String family = parts[0];
            int variantIndex = Integer.parseInt(parts[1]);
            if (family.startsWith("zoea_")) {
                if (!ALLOWED_FAMILIES.contains(family)) {
                    return null;
                }
                DeferredBlock<?>[] variants = ModBlocks.VARIANTS.get(family);
                if (variants == null || variants.length == 0) {
                    return null;
                }
                String prefix = family.split("_")[0];
                int baseIndex = Integer.parseInt(family.split("_")[1]);
                return this.getVariant(variants, variantIndex, reverse, this.getBaseKey(prefix, baseIndex));
            }
            if (ColorChangerItem.isColorFamily(family) && (colorResult = this.cycleColorKeepingVariant(family, variantIndex, reverse)) != null) {
                return colorResult;
            }
            if (!ALLOWED_FAMILIES.contains(family)) {
                return null;
            }
            DeferredBlock<?>[] variants = ModBlocks.VARIANTS.get(family);
            if (variants == null || variants.length == 0) {
                return null;
            }
            String prefix = family.split("_")[0];
            int baseIndex = Integer.parseInt(family.split("_")[1]);
            return this.getVariant(variants, variantIndex, reverse, this.getBaseKey(prefix, baseIndex));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Block cycleFromBase(String base, boolean reverse) {
        try {
            String[] parts = base.split("_blockz_");
            String prefix = parts[0];
            int groupIndex = Integer.parseInt(parts[1]);
            String variantKey = prefix + "_" + groupIndex;
            DeferredBlock<?>[] variants = ModBlocks.VARIANTS.get(variantKey);
            if (variants == null || variants.length == 0) {
                return null;
            }
            return reverse ? (Block)variants[variants.length - 1].get() : (Block)variants[0].get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Block getVariant(DeferredBlock<?>[] variants, int index, boolean reverse, String fallbackKey) {
        if (reverse) {
            return index == 0 ? ModBlocks.getBlockByKey(fallbackKey) : (Block)variants[index - 1].get();
        }
        return index == variants.length - 1 ? ModBlocks.getBlockByKey(fallbackKey) : (Block)variants[index + 1].get();
    }

    private String getBaseKey(String prefix, int index) {
        return prefix + "_blockz_" + index;
    }

    private void applyMode(Level level, BlockPos startPos, Block clickedBlock, String familyKey, int mode, Direction face, Consumer<BlockPos> replacer, Player player) {
        switch (mode) {
            case 0: {
                replacer.accept(startPos);
                break;
            }
            case 1: 
            case 2: {
                float pitch;
                int lineLength;
                int n = lineLength = mode == 1 ? 7 : 21;
                Direction lineDir = face.getAxis().isHorizontal() ? (player != null ? ((pitch = player.getViewXRot(1.0f)) < -30.0f ? Direction.UP : (pitch > 30.0f ? Direction.DOWN : player.getDirection().getCounterClockWise())) : face.getClockWise()) : (player != null ? player.getDirection() : Direction.NORTH);
                for (int i = 0; i < lineLength; ++i) {
                    BlockPos pos = startPos.relative(lineDir, i);
                    Block blockAtPos = level.getBlockState(pos).getBlock();
                    if (!this.isSameFamily(blockAtPos, clickedBlock, familyKey)) continue;
                    replacer.accept(pos);
                }
                break;
            }
            case 3: {
                this.floodFill2D(level, startPos, clickedBlock, face, replacer, familyKey, 100);
                break;
            }
            case 4: {
                this.floodFill2D(level, startPos, clickedBlock, face, replacer, familyKey, 800);
            }
        }
    }

    private void floodFill2D(Level level, BlockPos startPos, Block targetBlock, Direction face, Consumer<BlockPos> replacer, String familyKey, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        List<BlockPos> offsets = face == Direction.UP || face == Direction.DOWN ? List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1)) : (face.getAxis() == Direction.Axis.X ? List.of(new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(0, 1, 1), new BlockPos(0, 1, -1), new BlockPos(0, -1, 1), new BlockPos(0, -1, -1)) : List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(1, 1, 0), new BlockPos(1, -1, 0), new BlockPos(-1, 1, 0), new BlockPos(-1, -1, 0)));
        while (!queue.isEmpty() && visited.size() < maxBlocks) {
            BlockPos current = (BlockPos)queue.poll();
            Block blockAtPos = level.getBlockState(current).getBlock();
            if (!this.isSameFamily(blockAtPos, targetBlock, familyKey)) continue;
            replacer.accept(current);
            for (BlockPos offset : offsets) {
                Block neighborBlock;
                BlockPos neighbor = current.offset((Vec3i)offset);
                if (visited.contains(neighbor) || !level.isLoaded(neighbor) || !this.isSameFamily(neighborBlock = level.getBlockState(neighbor).getBlock(), targetBlock, familyKey)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
    }

    private String extractFamilyKey(Block block) {
        String key = block.getDescriptionId();
        if (!key.contains("block.betterblockz.")) {
            return null;
        }
        String name = key.split("block\\.betterblockz\\.")[1];
        if (name.contains("_blockz_")) {
            String family = name.split("_blockz_")[0];
            if (family.startsWith("zoea")) {
                return "zoea";
            }
            return family;
        }
        return null;
    }

    private boolean isSameFamily(Block block, Block target, String familyKey) {
        if (block == target) {
            return true;
        }
        if (familyKey == null) {
            return false;
        }
        String key = block.getDescriptionId();
        if (!key.contains("block.betterblockz.")) {
            return false;
        }
        String name = key.split("block\\.betterblockz\\.")[1];
        if (familyKey.equals("zoea")) {
            return name.startsWith("zoea_");
        }
        return name.startsWith(familyKey + "_blockz_");
    }

    private BlockState preserveRotation(Level level, BlockPos pos, Block replacement) {
        BlockState currentState = level.getBlockState(pos);
        BlockState newState = replacement.defaultBlockState();
        if (currentState.hasProperty((Property)BlockStateProperties.AXIS) && newState.hasProperty((Property)BlockStateProperties.AXIS)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.AXIS, (Comparable)((Direction.Axis)currentState.getValue((Property)BlockStateProperties.AXIS)));
        }
        for (Property prop : currentState.getProperties()) {
            if (!prop.getName().equals("facing") || !newState.hasProperty(prop) || !(prop instanceof DirectionProperty)) continue;
            DirectionProperty dirProp = (DirectionProperty)prop;
            newState = (BlockState)newState.setValue((Property)dirProp, (Comparable)((Direction)currentState.getValue((Property)dirProp)));
        }
        for (Property prop : currentState.getProperties()) {
            if (!(prop instanceof BooleanProperty)) continue;
            BooleanProperty boolProp = (BooleanProperty)prop;
            if (!prop.getName().equals("lit") || !newState.hasProperty((Property)boolProp)) continue;
            newState = (BlockState)newState.setValue((Property)boolProp, (Comparable)((Boolean)currentState.getValue((Property)boolProp)));
        }
        return newState;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            int currentMode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
            int nextMode = (currentMode + 1) % 5;
            stack.set(ModDataComponents.BUILDER_MODE, (Object)nextMode);
            String msg = switch (nextMode) {
                case 0 -> "Block Mode";
                case 1 -> "Line Mode (7)";
                case 2 -> "Line Mode (21)";
                case 3 -> "Area Mode Small";
                case 4 -> "Area Mode Large";
                default -> "";
            };
            player.displayClientMessage((Component)Component.literal((String)msg), true);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private static boolean isColorFamily(String family) {
        for (String color : COLOR_ORDER) {
            if (!family.endsWith("_" + color)) continue;
            return true;
        }
        return false;
    }

    private Block cycleColorKeepingVariant(String family, int variantIndex, boolean reverse) {
        String currentColor = null;
        for (String color : COLOR_ORDER) {
            if (!family.endsWith("_" + color)) continue;
            currentColor = color;
            break;
        }
        if (currentColor == null) {
            return null;
        }
        String prefix = family.substring(0, family.length() - currentColor.length() - 1);
        int colorIdx = Arrays.asList(COLOR_ORDER).indexOf(currentColor);
        int nextIdx = reverse ? (colorIdx == 0 ? COLOR_ORDER.length - 1 : colorIdx - 1) : (colorIdx == COLOR_ORDER.length - 1 ? 0 : colorIdx + 1);
        String nextColor = COLOR_ORDER[nextIdx];
        String newFamilyKey = prefix + "_" + nextColor;
        DeferredBlock<?>[] variants = ModBlocks.VARIANTS.get(newFamilyKey);
        if (variants == null || variants.length == 0) {
            return null;
        }
        if (variantIndex < 0 || variantIndex >= variants.length) {
            return null;
        }
        return (Block)variants[variantIndex].get();
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line3")));
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.betterblockz.supported_sets").withStyle(ChatFormatting.GOLD));
            for (String key : CYCLING_BASES) {
                tooltip.add((Component)Component.literal((String)"\u2022 ").append((Component)Component.translatable((String)("block.betterblockz." + key))));
            }
            tooltip.add((Component)Component.literal((String)"\u2022 ").append((Component)Component.translatable((String)"tooltip.betterblockz.color_support")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    static {
        for (String base : CYCLING_BASES) {
            if (!base.contains("_blockz_")) continue;
            String[] parts = base.split("_blockz_");
            String prefix = parts[0];
            String index = parts[1];
            ALLOWED_FAMILIES.add(prefix + "_" + index);
        }
        COLOR_ORDER = new String[]{"white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink"};
    }
}

