/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.datagen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.block.custom.CobbleTransmuterBlock;
import net.ricmc.betterblockz.block.custom.FlatBarLightBlock;
import net.ricmc.betterblockz.block.custom.FlatBarLightVerticalBlock;
import net.ricmc.betterblockz.block.custom.LightPanelBlock;
import net.ricmc.betterblockz.block.custom.TopRotateBlock;
import net.ricmc.betterblockz.block.custom.WallOrFloorLightBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    private final PackOutput packOutput;
    private static final Set<String> GLOWING_CTM_PREFIXES = Set.of("zeon");

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "betterblockz", exFileHelper);
        this.packOutput = output;
    }

    protected void registerStatesAndModels() {
        ModelBuilder baseModel;
        String texturePath;
        String idx;
        String name;
        this.blockWithItem(ModBlocks.DIRT_BLOCKZ);
        this.blockWithItem(ModBlocks.STONE_BLOCKZ);
        this.blockWithItem(ModBlocks.Z_MOVING);
        this.blockWithItem(ModBlocks.AURORA_BLOCKZ);
        this.blockWithItem(ModBlocks.VARIANT_SHUFFLER);
        this.blockWithItem(ModBlocks.BLOCKZ_CORE);
        this.registerCobbleTransmuter();
        ModBlocks.VARIANTS.forEach((baseName, blocks) -> {
            int[] pillars = ModBlocks.VARIANTS_PILLARS.getOrDefault(baseName, new int[0]);
            int[] ctmIndices = ModBlocks.VARIANTS_CTM.getOrDefault(baseName, new int[0]);
            ModBlocks.BaseConfig config = ModBlocks.BASE_CONFIGS.get(baseName);
            int[] rotatables = config != null ? config.rotatables() : new int[]{};
            int[] topRotates = config != null ? config.topRotates() : new int[]{};
            int[] muralIndices = config != null ? config.mural() : new int[]{};
            for (int i = 0; i < ((DeferredBlock[])blocks).length; ++i) {
                DeferredBlock block = blocks[i];
                String name = block.getId().getPath();
                Set<String> cyberlightBases = Set.of("cyberlight", "cyberlight_alt", "cyberlight_secret", "cyberlight_bar");
                Set<String> tintedglassBases = Set.of("tintedglass");
                Set<String> numberBases = Set.of("number");
                if (this.contains(pillars, i)) {
                    this.registerPillarBlock((DeferredBlock<? extends Block>)block, name);
                    continue;
                }
                if (this.contains(ctmIndices, i)) {
                    this.registerCTMBlock(block, name);
                    continue;
                }
                if (this.contains(rotatables, i)) {
                    this.registerRotatableBlock(block, name);
                    continue;
                }
                if (this.contains(topRotates, i)) {
                    this.registerTopRotateBlock((DeferredBlock<? extends Block>)block, name);
                    continue;
                }
                if (cyberlightBases.contains(baseName)) {
                    this.registerCyberlightFullVariant((DeferredBlock<?>)block, name, (String)baseName);
                    continue;
                }
                if (baseName.startsWith("zeon")) {
                    this.registerZeonBlocks((DeferredBlock<?>)block, name, (String)baseName);
                    continue;
                }
                if (tintedglassBases.contains(baseName)) {
                    this.registerTintedGlass((DeferredBlock<?>)block, name, (String)baseName);
                    continue;
                }
                if (numberBases.contains(baseName)) {
                    this.registerNumberBlock(block, name);
                    continue;
                }
                if (this.contains(muralIndices, i)) {
                    this.registerMuralBlock(block, name);
                    continue;
                }
                this.registerBlockVariant(block, name);
            }
        });
        for (DeferredBlock<Block> block : ModBlocks.CYBERLIGHT_THIN) {
            name = block.getId().getPath();
            idx = name.substring(name.lastIndexOf("_") + 1);
            texturePath = "block/cyberlight_blockz_" + idx;
            baseModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/cyberlight_thin_base"))).texture("all", this.modLoc(texturePath))).texture("particle", this.modLoc(texturePath));
            this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerStatesAndModels$1((ModelFile)baseModel, arg_0));
            this.itemModels().withExistingParent(name, baseModel.getLocation());
        }
        for (DeferredBlock<Block> block : ModBlocks.CYBERLIGHT_THIN_ALT) {
            name = block.getId().getPath();
            idx = name.substring(name.lastIndexOf("_") + 1);
            texturePath = "block/cyberlight_panel_blockz_" + idx;
            baseModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/cyberlight_thin_alt_base"))).texture("all", this.modLoc(texturePath))).texture("particle", this.modLoc(texturePath));
            this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerStatesAndModels$2((ModelFile)baseModel, arg_0));
            this.itemModels().withExistingParent(name, baseModel.getLocation());
        }
        for (DeferredBlock<Block> block : ModBlocks.CYBERLIGHT_BAR) {
            name = block.getId().getPath();
            idx = name.substring(name.lastIndexOf("_") + 1);
            texturePath = "block/cyberlight_bar_blockz_" + idx;
            baseModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/cyberlight_bar_base"))).texture("all", this.modLoc(texturePath))).texture("particle", this.modLoc(texturePath));
            this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerStatesAndModels$3((ModelFile)baseModel, arg_0));
            this.itemModels().withExistingParent(name, baseModel.getLocation());
        }
        for (DeferredBlock<Block> block : ModBlocks.CYBERLIGHT_BAR_VERTICAL) {
            name = block.getId().getPath();
            idx = name.substring(name.lastIndexOf("_") + 1);
            texturePath = "block/cyberlight_bar_vertical_blockz_" + idx;
            baseModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/cyberlight_bar_vertical_base"))).texture("all", this.modLoc(texturePath))).texture("particle", this.modLoc(texturePath));
            this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerStatesAndModels$4((ModelFile)baseModel, arg_0));
            this.itemModels().withExistingParent(name, baseModel.getLocation());
        }
    }

    private void registerCyberlightFullVariant(DeferredBlock<?> block, String name, String baseName) {
        String texture = baseName + "_blockz_" + this.getIndex(block);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/cyberlight_base"))).texture("all", this.modLoc("block/" + texture))).texture("particle", this.modLoc("block/" + texture))).build());
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(name, this.modLoc("block/cyberlight_base"))).texture("all", this.modLoc("block/" + texture))).texture("particle", this.modLoc("block/" + texture));
    }

    private void registerZeonBlocks(DeferredBlock<?> block, String name, String baseName) {
        String texture = baseName + "_blockz_" + this.getIndex(block);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/zeon_base"))).texture("all", this.modLoc("block/" + texture))).texture("particle", this.modLoc("block/" + texture))).build());
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(name, this.modLoc("block/zeon_base"))).texture("all", this.modLoc("block/" + texture))).texture("particle", this.modLoc("block/" + texture));
    }

    private void registerTintedGlass(DeferredBlock<?> block, String name, String baseName) {
        String texture = baseName + "_blockz_" + this.getIndex(block);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/tintedglass_base"))).texture("all", this.modLoc("block/" + texture))).texture("particle", this.modLoc("block/" + texture))).build());
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(name, this.modLoc("block/tintedglass_base"))).texture("all", this.modLoc("block/" + texture))).texture("particle", this.modLoc("block/" + texture));
    }

    private int getIndex(DeferredBlock<?> block) {
        String path = block.getId().getPath();
        return Integer.parseInt(path.replaceAll("\\D+", ""));
    }

    private void registerBlockVariant(DeferredBlock<?> block, String name) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(name, this.modLoc("block/" + name))).build());
        this.itemModels().withExistingParent(name, this.modLoc("block/" + name));
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void registerPillarBlock(DeferredBlock<? extends Block> block, String name) {
        boolean isZeon = name.startsWith("zeon");
        String sideTex = "block/" + name + "_side";
        String topTex = "block/" + name + "_top";
        if (isZeon) {
            ModelBuilder vertical = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/zeon_column_base"))).texture("side", this.modLoc(sideTex))).texture("end", this.modLoc(topTex))).texture("particle", this.modLoc(sideTex));
            ModelBuilder horizontal = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_horizontal", this.modLoc("block/zeon_column_base_horizontal"))).texture("side", this.modLoc(sideTex))).texture("end", this.modLoc(topTex))).texture("particle", this.modLoc(sideTex));
            this.axisBlock((RotatedPillarBlock)block.get(), (ModelFile)vertical, (ModelFile)horizontal);
        } else {
            this.axisBlock((RotatedPillarBlock)block.get(), this.modLoc(sideTex), this.modLoc(topTex));
        }
        this.itemModels().withExistingParent(name, this.modLoc("block/" + name));
    }

    private void registerRotatableBlock(DeferredBlock<?> block, String name) {
        ModelBuilder baseModel = this.models().cubeAll(name, this.modLoc("block/" + name));
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerRotatableBlock$9((ModelFile)baseModel, arg_0));
        this.itemModels().withExistingParent(name, baseModel.getLocation());
    }

    private void registerTopRotateBlock(DeferredBlock<? extends Block> block, String baseName) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)TopRotateBlock.FACING);
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName, "block/cube")).texture("north", this.modLoc("block/" + baseName))).texture("south", this.modLoc("block/" + baseName + "_side"))).texture("east", this.modLoc("block/" + baseName + "_side"))).texture("west", this.modLoc("block/" + baseName + "_side"))).texture("up", this.modLoc("block/" + baseName + "_side"))).texture("down", this.modLoc("block/" + baseName + "_side"))).texture("particle", this.modLoc("block/" + baseName + "_side"));
            int xRot = 0;
            int yRot = switch (facing) {
                case Direction.NORTH -> 0;
                case Direction.EAST -> 90;
                case Direction.SOUTH -> 180;
                case Direction.WEST -> 270;
                case Direction.UP -> {
                    xRot = 270;
                    yield 0;
                }
                case Direction.DOWN -> {
                    xRot = 90;
                    yield 0;
                }
                default -> 0;
            };
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationX(xRot).rotationY(yRot).build();
        });
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(baseName, this.modLoc("block/" + baseName))).texture("north", this.modLoc("block/" + baseName + "_side"))).texture("south", this.modLoc("block/" + baseName + "_side"))).texture("east", this.modLoc("block/" + baseName + "_side"))).texture("west", this.modLoc("block/" + baseName + "_side"))).texture("up", this.modLoc("block/" + baseName))).texture("down", this.modLoc("block/" + baseName + "_side"))).texture("particle", this.modLoc("block/" + baseName + "_side"));
    }

    private void registerCTMBlock(DeferredBlock<?> block, String name) {
        this.writeCTMBlockstate(name);
        String baseName = name.substring(0, name.indexOf("_blockz"));
        boolean isGlowing = GLOWING_CTM_PREFIXES.stream().anyMatch(baseName::startsWith);
        ModelBuilder model = isGlowing ? ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/zeon_base"))).texture("all", this.modLoc("block/" + name))).texture("particle", this.modLoc("block/" + name)) : this.models().cubeAll(name, this.modLoc("block/" + name));
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerCTMBlock$11((ModelFile)model, arg_0));
        if (isGlowing) {
            ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(name, this.modLoc("block/zeon_base"))).texture("all", this.modLoc("block/" + name))).texture("particle", this.modLoc("block/" + name));
        } else {
            this.itemModels().cubeAll(name, this.modLoc("block/" + name));
        }
    }

    private void writeCTMBlockstate(String name) {
        Path path = this.packOutput.getOutputFolder().resolve("assets/betterblockz/blockstates/" + name + ".json");
        String json = "{\n  \"variants\": {\n    \"\": {\n      \"model\": \"betterblockz:block/%s\"\n    }\n  },\n  \"athena:loader\": \"athena:ctm\",\n  \"ctm_textures\": {\n    \"center\": \"betterblockz:block/ctm/%s/center\",\n    \"empty\": \"betterblockz:block/ctm/%s/empty\",\n    \"horizontal\": \"betterblockz:block/ctm/%s/horizontal\",\n    \"vertical\": \"betterblockz:block/ctm/%s/vertical\",\n    \"particle\": \"betterblockz:block/ctm/%s/particle\"\n  }\n}\n".formatted(name, name, name, name, name, name);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write CTM blockstate for " + name, e);
        }
    }

    private void registerMuralBlock(DeferredBlock<?> block, String name) {
        this.writeMuralBlockstate(name);
        ModelBuilder model = this.models().cubeAll(name, this.modLoc("block/" + name));
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerMuralBlock$12((ModelFile)model, arg_0));
        this.itemModels().cubeAll(name, this.modLoc("block/" + name));
    }

    private void writeMuralBlockstate(String name) {
        Path path = this.packOutput.getOutputFolder().resolve("assets/betterblockz/blockstates/" + name + ".json");
        String json = "{\n  \"variants\": {\n    \"\": {\n      \"model\": \"betterblockz:block/%s\"\n    }\n  },\n  \"athena:loader\": \"athena:giant\",\n  \"ctm_textures\": {\n    \"1\": \"betterblockz:block/ctm/%s/0\",\n    \"2\": \"betterblockz:block/ctm/%s/1\",\n    \"3\": \"betterblockz:block/ctm/%s/2\",\n    \"4\": \"betterblockz:block/ctm/%s/3\",\n    \"particle\": \"betterblockz:block/ctm/%s/particle\"\n  },\n  \"height\": 2,\n  \"width\": 2\n}\n".formatted(name, name, name, name, name, name);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write mural blockstate for " + name, e);
        }
    }

    private void registerNumberBlock(DeferredBlock<?> block, String name) {
        for (int i = 0; i <= 9; ++i) {
            String modelName = name + "_" + i;
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/number_base"))).texture("all", this.modLoc("block/number/" + modelName))).texture("particle", this.modLoc("block/number/" + modelName));
        }
        ((ItemModelBuilder)this.itemModels().withExistingParent(name, "item/generated")).texture("layer0", this.modLoc("block/number/" + name));
    }

    private boolean contains(int[] arr, int value) {
        for (int v : arr) {
            if (v != value) continue;
            return true;
        }
        return false;
    }

    private void registerCobbleTransmuter() {
        String baseName = ModBlocks.TRANSMUTER_BLOCKZ.getId().getPath();
        ModelBuilder normal = this.models().cubeAll(baseName + "_normal", this.modLoc("block/" + baseName + "_normal"));
        ModelBuilder lava = this.models().cubeAll(baseName + "_lava", this.modLoc("block/" + baseName + "_lava"));
        ModelBuilder water = this.models().cubeAll(baseName + "_water", this.modLoc("block/" + baseName + "_water"));
        this.getVariantBuilder((Block)ModBlocks.TRANSMUTER_BLOCKZ.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerCobbleTransmuter$13((ModelFile)lava, (ModelFile)water, (ModelFile)normal, arg_0));
        this.itemModels().withExistingParent(baseName, this.modLoc("block/" + baseName + "_normal"));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCobbleTransmuter$13(ModelFile lava, ModelFile water, ModelFile normal, BlockState state) {
        CobbleTransmuterBlock.Mode mode = (CobbleTransmuterBlock.Mode)((Object)state.getValue(CobbleTransmuterBlock.MODE));
        ModelFile model = switch (mode) {
            case CobbleTransmuterBlock.Mode.LAVA -> lava;
            case CobbleTransmuterBlock.Mode.WATER -> water;
            default -> normal;
        };
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerMuralBlock$12(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCTMBlock$11(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerRotatableBlock$9(ModelFile baseModel, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)DirectionalBlock.FACING);
        int xRot = switch (facing) {
            case Direction.DOWN -> 180;
            case Direction.UP -> 0;
            default -> 90;
        };
        int yRot = switch (facing) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
        return ConfiguredModel.builder().modelFile(baseModel).rotationX(xRot).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$4(ModelFile baseModel, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FlatBarLightVerticalBlock.FACING);
        int xRot = switch (facing) {
            case Direction.UP -> 0;
            case Direction.DOWN -> 180;
            default -> 90;
        };
        int yRot = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.UP, Direction.DOWN -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
        return ConfiguredModel.builder().modelFile(baseModel).rotationX(xRot).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$3(ModelFile baseModel, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FlatBarLightBlock.FACING);
        int xRot = switch (facing) {
            case Direction.UP -> 0;
            case Direction.DOWN -> 180;
            default -> 90;
        };
        int yRot = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.UP, Direction.DOWN -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
        return ConfiguredModel.builder().modelFile(baseModel).rotationX(xRot).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$2(ModelFile baseModel, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)LightPanelBlock.FACING);
        int xRot = switch (facing) {
            case Direction.UP -> 0;
            case Direction.DOWN -> 180;
            default -> 90;
        };
        int yRot = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.UP, Direction.DOWN -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
        return ConfiguredModel.builder().modelFile(baseModel).rotationX(xRot).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$1(ModelFile baseModel, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)WallOrFloorLightBlock.FACING);
        int xRot = switch (facing) {
            case Direction.UP -> 0;
            case Direction.DOWN -> 180;
            default -> 90;
        };
        int yRot = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.UP, Direction.DOWN -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
        return ConfiguredModel.builder().modelFile(baseModel).rotationX(xRot).rotationY(yRot).build();
    }
}

