/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.ricmc.betterblockz.datagen.BetterBlockZLangProvider;
import net.ricmc.betterblockz.datagen.ModBlockLootTableProvider;
import net.ricmc.betterblockz.datagen.ModBlockStateProvider;
import net.ricmc.betterblockz.datagen.ModBlockTagProvider;
import net.ricmc.betterblockz.datagen.ModItemModelProvider;
import net.ricmc.betterblockz.datagen.ModItemTagProvider;
import net.ricmc.betterblockz.datagen.ModRecipeProvider;

@EventBusSubscriber(modid="betterblockz")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        ModBlockTagProvider blockTags = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTags, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BetterBlockZLangProvider(generator));
    }
}

