/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block.custom;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlatBarLightBlock
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", Arrays.asList(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST));
    private static final VoxelShape FLOOR = Block.box((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)1.0, (double)12.0);
    private static final VoxelShape CEILING = Block.box((double)1.0, (double)15.0, (double)4.0, (double)15.0, (double)16.0, (double)12.0);
    private static final VoxelShape WALL_NORTH = Block.box((double)1.0, (double)4.0, (double)15.0, (double)15.0, (double)12.0, (double)16.0);
    private static final VoxelShape WALL_SOUTH = Block.box((double)1.0, (double)4.0, (double)0.0, (double)15.0, (double)12.0, (double)1.0);
    private static final VoxelShape WALL_WEST = Block.box((double)15.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)15.0);
    private static final VoxelShape WALL_EAST = Block.box((double)0.0, (double)4.0, (double)1.0, (double)1.0, (double)12.0, (double)15.0);

    public FlatBarLightBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> FLOOR;
            case Direction.DOWN -> CEILING;
            case Direction.NORTH -> WALL_NORTH;
            case Direction.SOUTH -> WALL_SOUTH;
            case Direction.WEST -> WALL_WEST;
            case Direction.EAST -> WALL_EAST;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clickedFace);
    }
}

