/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block.custom;

import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class DrainBlock
extends Block {
    private static final int RADIUS = 5;

    public DrainBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            this.absorbWater((ServerLevel)level, pos);
        }
    }

    private void absorbWater(ServerLevel level, BlockPos origin) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(origin);
        int absorbed = 0;
        while (!queue.isEmpty() && absorbed < 64) {
            BlockPos current = (BlockPos)queue.poll();
            for (Direction dir : Direction.values()) {
                BlockState targetState;
                BlockPos target = current.relative(dir);
                if (origin.distManhattan((Vec3i)target) > 5 || !(targetState = level.getBlockState(target)).getFluidState().isSource()) continue;
                level.setBlock(target, Blocks.AIR.defaultBlockState(), 3);
                ++absorbed;
                queue.add(target);
            }
        }
    }
}

