/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.util.ColorCycleRegistry;
import org.jetbrains.annotations.NotNull;

public class ConversionBlock
extends Block {
    public ConversionBlock(@NotNull BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void stepOn(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        Item nextWool;
        if (level.isClientSide || !(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (itemEntity.getAge() != 5) {
            return;
        }
        @NotNull ItemStack stack = itemEntity.getItem();
        DeferredBlock<?>[] cyberlightVariants = ModBlocks.VARIANTS.get("cyberlight");
        DeferredBlock<?>[] secretVariants = ModBlocks.VARIANTS.get("cyberlight_secret");
        if (cyberlightVariants != null && secretVariants != null && cyberlightVariants.length > 0 && secretVariants.length > 0) {
            Block cyberlight = (Block)cyberlightVariants[0].get();
            Block secret = (Block)secretVariants[0].get();
            if (stack.is(cyberlight.asItem())) {
                itemEntity.setItem(new ItemStack((ItemLike)secret, stack.getCount()));
                level.playSound(null, pos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                return;
            }
        }
        if ((nextWool = ColorCycleRegistry.WOOL_CYCLE.get(stack.getItem())) != null) {
            itemEntity.setItem(new ItemStack((ItemLike)nextWool, stack.getCount()));
            level.playSound(null, pos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        Item nextGlass = ColorCycleRegistry.GLASS_CYCLE.get(stack.getItem());
        if (nextGlass != null) {
            itemEntity.setItem(new ItemStack((ItemLike)nextGlass, stack.getCount()));
            level.playSound(null, pos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        Item nextTerracotta = ColorCycleRegistry.TERRACOTTA_CYCLE.get(stack.getItem());
        if (nextTerracotta != null) {
            itemEntity.setItem(new ItemStack((ItemLike)nextTerracotta, stack.getCount()));
            level.playSound(null, pos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
    }
}

