/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.network;

import com.breakinblocks.beer.Beer;
import com.breakinblocks.beer.data.EnchantingTableRangeData;
import com.breakinblocks.beer.network.NetworkHandler;
import com.breakinblocks.beer.network.SyncEnchantingDataPacket;
import com.breakinblocks.beer.util.EnchantingTableDataUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RequestEnchantingDataPacket(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestEnchantingDataPacket> TYPE = new CustomPacketPayload.Type(Beer.rl("request_enchanting_data"));
    public static final StreamCodec<ByteBuf, RequestEnchantingDataPacket> STREAM_CODEC = new StreamCodec<ByteBuf, RequestEnchantingDataPacket>(){

        @NotNull
        public RequestEnchantingDataPacket decode(@NotNull ByteBuf buffer) {
            BlockPos pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buffer);
            return new RequestEnchantingDataPacket(pos);
        }

        public void encode(@NotNull ByteBuf buffer, RequestEnchantingDataPacket packet) {
            BlockPos.STREAM_CODEC.encode((Object)buffer, (Object)packet.pos());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RequestEnchantingDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer;
            ServerLevel level;
            BlockEntity blockEntity;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (blockEntity = (level = (serverPlayer = (ServerPlayer)patt0$temp).serverLevel()).getBlockEntity(packet.pos())) instanceof EnchantingTableBlockEntity) {
                EnchantingTableRangeData data = EnchantingTableDataUtil.getRangeData((Level)level, packet.pos());
                SyncEnchantingDataPacket syncPacket = SyncEnchantingDataPacket.create(packet.pos(), data);
                NetworkHandler.sendToPlayer(syncPacket, serverPlayer);
            }
        });
    }

    public static RequestEnchantingDataPacket create(BlockPos pos) {
        return new RequestEnchantingDataPacket(pos);
    }
}

