/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.compat;

import com.breakinblocks.beer.data.EnchantingTableRangeData;
import com.breakinblocks.beer.network.NetworkHandler;
import com.breakinblocks.beer.network.RequestEnchantingDataPacket;
import com.breakinblocks.beer.util.EnchantingTableDataUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class BeerJadePlugin
implements IWailaPlugin,
IBlockComponentProvider {
    private static final Set<BlockPos> pendingRequests = ConcurrentHashMap.newKeySet();

    public void registerClient(IWailaClientRegistration reg) {
        reg.registerBlockComponent((IComponentProvider)this, Block.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() == Blocks.ENCHANTING_TABLE) {
            try {
                BlockEntity blockEntity;
                EnchantingTableRangeData data = EnchantingTableDataUtil.getRangeData(accessor.getLevel(), accessor.getPosition());
                if (accessor.getLevel().isClientSide() && (blockEntity = accessor.getLevel().getBlockEntity(accessor.getPosition())) != null && !data.hasItemModifications() && !pendingRequests.contains(accessor.getPosition())) {
                    pendingRequests.add(accessor.getPosition());
                    RequestEnchantingDataPacket requestPacket = RequestEnchantingDataPacket.create(accessor.getPosition());
                    NetworkHandler.sendToServer(requestPacket);
                }
                int[] boundingBoxSizes = EnchantingTableDataUtil.getEffectiveBoundingBoxSizes(accessor.getLevel(), accessor.getPosition());
                tooltip.add((Component)Component.translatable((String)"tooltip.beer.enchanting_table.range", (Object[])new Object[]{boundingBoxSizes[0], boundingBoxSizes[1], boundingBoxSizes[2]}).withStyle(ChatFormatting.GRAY));
                if (data.hasItemModifications()) {
                    tooltip.add((Component)Component.literal((String)("\u00a78[Item mods: " + data.getItemModifiersX() + "," + data.getItemModifiersY() + "," + data.getItemModifiersZ() + "]")));
                }
            }
            catch (Exception e) {
                tooltip.add((Component)Component.literal((String)"\u00a7cError reading enchanting table data").withStyle(ChatFormatting.RED));
            }
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"beer", (String)"beer");
    }

    public static void clearPendingRequest(BlockPos pos) {
        pendingRequests.remove(pos);
    }
}

