/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.mixin;

import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import me.axieum.mcmod.authme.api.AuthMe;
import me.axieum.mcmod.authme.api.gui.screen.AuthMethodScreen;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.realms.RealmsScreen;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RealmsGenericErrorScreen.class})
public abstract class RealmsGenericErrorScreenMixin
extends RealmsScreen {
    @Shadow
    @Final
    private Screen nextScreen;
    @Shadow
    @Final
    private RealmsGenericErrorScreen.ErrorMessage lines;

    private RealmsGenericErrorScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (RealmsGenericErrorScreenMixin.authme$isUserRelated(this.lines.detail())) {
            AuthMe.LOGGER.info("Adding auth button to the Realms error screen");
            assert (this.minecraft != null);
            Button backButton = (Button)this.children().getFirst();
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.authme.button.relogin"), btn -> this.minecraft.setScreen((Screen)new AuthMethodScreen(this.nextScreen))).bounds(backButton.getX(), backButton.getY() - backButton.getHeight() - 4, backButton.getWidth(), backButton.getHeight()).build());
        }
    }

    @Unique
    private static boolean authme$isUserRelated(@Nullable Component reason) {
        ComponentContents componentContents;
        if (reason != null && (componentContents = reason.getContents()) instanceof TranslatableContents) {
            TranslatableContents content = (TranslatableContents)componentContents;
            return content.getKey().startsWith("mco.error.invalid.session");
        }
        return false;
    }
}

