/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.retaliation;

import artifacts.component.ability.retaliation.RetaliationEffect;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ThornsEffect
extends RetaliationEffect {
    public static final Codec<ThornsEffect> CODEC = RecordCodecBuilder.create(instance -> ThornsEffect.codecStart(instance).and((App)ValueTypes.NON_NEGATIVE_INT.codec().fieldOf("min_damage").forGetter(ThornsEffect::minDamage)).and((App)ValueTypes.NON_NEGATIVE_INT.codec().fieldOf("max_damage").forGetter(ThornsEffect::maxDamage)).apply((Applicative)instance, ThornsEffect::new));
    public static final StreamCodec<ByteBuf, ThornsEffect> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), RetaliationEffect::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationEffect::cooldown, ValueTypes.NON_NEGATIVE_INT.streamCodec(), ThornsEffect::minDamage, ValueTypes.NON_NEGATIVE_INT.streamCodec(), ThornsEffect::maxDamage, ThornsEffect::new);
    private final Value<Integer> minDamage;
    private final Value<Integer> maxDamage;

    public ThornsEffect(Value<Double> strikeChance, Value<Integer> cooldown, Value<Integer> minDamage, Value<Integer> maxDamage) {
        super("thorns", strikeChance, cooldown);
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
    }

    public Value<Integer> minDamage() {
        return this.minDamage;
    }

    public Value<Integer> maxDamage() {
        return this.maxDamage;
    }

    @Override
    public boolean isNonCosmetic() {
        return super.isNonCosmetic() && (Integer)this.maxDamage().get() > 0;
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        if (attacker.attackable()) {
            int damage;
            int minDamage = (Integer)this.minDamage().get();
            int maxDamage = (Integer)this.maxDamage().get();
            if (maxDamage < minDamage) {
                minDamage = maxDamage;
            }
            if ((damage = minDamage + target.getRandom().nextInt(maxDamage - minDamage + 1)) > 0) {
                attacker.hurt(target.damageSources().thorns((Entity)target), (float)damage);
            }
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThornsEffect)) {
            return false;
        }
        ThornsEffect that = (ThornsEffect)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.minDamage.equals(that.minDamage) && this.maxDamage.equals(that.maxDamage);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.minDamage.hashCode();
        result = 31 * result + this.maxDamage.hashCode();
        return result;
    }
}

