/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.sandbox.facet.cutters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.ars_nouveau.facet.FacetsConfig;
import org.apache.lucene.ars_nouveau.facet.taxonomy.FacetLabel;
import org.apache.lucene.ars_nouveau.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.ars_nouveau.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.ars_nouveau.index.DocValues;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.SortedNumericDocValues;
import org.apache.lucene.ars_nouveau.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.ars_nouveau.sandbox.facet.cutters.LeafFacetCutter;
import org.apache.lucene.ars_nouveau.sandbox.facet.iterators.OrdinalIterator;

public final class TaxonomyFacetsCutter
implements FacetCutter {
    private final FacetsConfig facetsConfig;
    private final TaxonomyReader taxoReader;
    private final String indexFieldName;
    private final boolean disableRollup;
    private ParallelTaxonomyArrays.IntArray children;
    private ParallelTaxonomyArrays.IntArray siblings;

    public TaxonomyFacetsCutter(String indexFieldName, FacetsConfig facetsConfig, TaxonomyReader taxoReader) {
        this(indexFieldName, facetsConfig, taxoReader, false);
    }

    public TaxonomyFacetsCutter(String indexFieldName, FacetsConfig facetsConfig, TaxonomyReader taxoReader, boolean disableRollup) {
        this.facetsConfig = facetsConfig;
        this.indexFieldName = indexFieldName;
        this.taxoReader = taxoReader;
        this.disableRollup = disableRollup;
    }

    ParallelTaxonomyArrays.IntArray getChildren() throws IOException {
        if (this.children == null) {
            this.children = this.taxoReader.getParallelTaxonomyArrays().children();
        }
        return this.children;
    }

    ParallelTaxonomyArrays.IntArray getSiblings() throws IOException {
        if (this.siblings == null) {
            this.siblings = this.taxoReader.getParallelTaxonomyArrays().siblings();
        }
        return this.siblings;
    }

    @Override
    public LeafFacetCutter createLeafCutter(LeafReaderContext context) throws IOException {
        SortedNumericDocValues multiValued = DocValues.getSortedNumeric(context.reader(), this.indexFieldName);
        assert (multiValued != null);
        TaxonomyLeafFacetCutterMultiValue leafCutter = new TaxonomyLeafFacetCutterMultiValue(multiValued);
        return leafCutter;
    }

    @Override
    public OrdinalIterator getOrdinalsToRollup() throws IOException {
        if (this.disableRollup) {
            return null;
        }
        Iterator<Map.Entry<String, FacetsConfig.DimConfig>> dimensions = this.facetsConfig.getDimConfigs().entrySet().iterator();
        ArrayList<FacetLabel> dimsToRollup = new ArrayList<FacetLabel>();
        while (dimensions.hasNext()) {
            Map.Entry<String, FacetsConfig.DimConfig> ent = dimensions.next();
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued || !ft.indexFieldName.equals(this.indexFieldName)) continue;
            dimsToRollup.add(new FacetLabel(dim));
        }
        final int[] dimOrdToRollup = this.taxoReader.getBulkOrdinals(dimsToRollup.toArray(new FacetLabel[0]));
        return new OrdinalIterator(){
            int currentIndex = 0;

            @Override
            public int nextOrd() throws IOException {
                while (this.currentIndex < dimOrdToRollup.length) {
                    if (dimOrdToRollup[this.currentIndex] != -1) {
                        return dimOrdToRollup[this.currentIndex++];
                    }
                    ++this.currentIndex;
                }
                return -1;
            }
        };
    }

    @Override
    public OrdinalIterator getChildrenOrds(final int parentOrd) throws IOException {
        final ParallelTaxonomyArrays.IntArray children = this.getChildren();
        final ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
        return new OrdinalIterator(){
            int currentChild;
            {
                this.currentChild = parentOrd;
            }

            @Override
            public int nextOrd() {
                this.currentChild = this.currentChild == parentOrd ? children.get(this.currentChild) : siblings.get(this.currentChild);
                if (this.currentChild != -1) {
                    return this.currentChild;
                }
                return -1;
            }
        };
    }

    private static class TaxonomyLeafFacetCutterMultiValue
    implements LeafFacetCutter {
        private final SortedNumericDocValues multiValued;
        private int ordsInDoc;

        private TaxonomyLeafFacetCutterMultiValue(SortedNumericDocValues multiValued) {
            this.multiValued = multiValued;
        }

        @Override
        public int nextOrd() throws IOException {
            if (this.ordsInDoc > 0) {
                --this.ordsInDoc;
                return (int)this.multiValued.nextValue();
            }
            return -1;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            if (this.multiValued.advanceExact(doc)) {
                this.ordsInDoc = this.multiValued.docValueCount();
                return true;
            }
            return false;
        }
    }
}

