/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.FamiliarSummonEvent;
import com.hollingsworth.arsnouveau.api.familiar.IFamiliar;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.capability.FamiliarData;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.PacketDispelFamiliars;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class PacketToggleFamiliar
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketToggleFamiliar> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("toggle_familiar"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketToggleFamiliar> CODEC = StreamCodec.ofMember(PacketToggleFamiliar::toBytes, PacketToggleFamiliar::new);

    public PacketToggleFamiliar() {
    }

    public PacketToggleFamiliar(RegistryFriendlyByteBuf buf) {
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer owner) {
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)owner);
        if (cap == null) {
            return;
        }
        if (PacketDispelFamiliars.dispelForPlayer((Entity)owner)) {
            return;
        }
        FamiliarData lastSummoned = cap.getLastSummonedFamiliar();
        if (lastSummoned == null) {
            return;
        }
        IFamiliar familiarEntity = lastSummoned.getEntity(owner.level);
        familiarEntity.setOwnerID(owner.getUUID());
        familiarEntity.getThisEntity().setPos(owner.getX(), owner.getY(), owner.getZ());
        FamiliarSummonEvent summonEvent = new FamiliarSummonEvent(familiarEntity.getThisEntity(), (Entity)owner);
        NeoForge.EVENT_BUS.post((Event)summonEvent);
        if (!summonEvent.isCanceled()) {
            owner.level.addFreshEntity(familiarEntity.getThisEntity());
            ParticleUtil.spawnPoof((ServerLevel)owner.level, familiarEntity.getThisEntity().blockPosition());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

