/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class PacketSyncLitEntities
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketSyncLitEntities> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("sync_lit_entities"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSyncLitEntities> CODEC = StreamCodec.ofMember(PacketSyncLitEntities::toBytes, PacketSyncLitEntities::new);
    List<Integer> entityIDs = new ArrayList<Integer>();

    public PacketSyncLitEntities(RegistryFriendlyByteBuf buf) {
        int num = buf.readInt();
        for (int i = 0; i < num; ++i) {
            this.entityIDs.add(buf.readInt());
        }
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityIDs.size());
        for (Integer i : this.entityIDs) {
            buf.writeInt(i.intValue());
        }
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        if (LightManager.shouldUpdateDynamicLight()) {
            LightManager.jarHoldingEntityList = this.entityIDs;
        }
    }

    public PacketSyncLitEntities(List<Integer> entityIDs) {
        this.entityIDs = entityIDs;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

