/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.nbt.AbstractData;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FrogBehavior
extends JarBehavior<Frog> {
    @Override
    public void tick(MobJarTile tile) {
        if (tile.getLevel().isClientSide) {
            return;
        }
        ExtraData data = new ExtraData(tile.getExtraDataTag());
        if (data.isEating) {
            if (data.tickCounter >= 8) {
                Entity target = tile.getLevel().getEntity(data.entityId);
                if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    Frog frog = (Frog)this.entityFromJar(tile);
                    livingEntity.playSound(SoundEvents.FROG_EAT, 2.0f, 1.0f);
                    if (livingEntity.isAlive()) {
                        frog.doHurtTarget((Entity)livingEntity);
                        if (!livingEntity.isAlive()) {
                            livingEntity.remove(Entity.RemovalReason.KILLED);
                        }
                    }
                }
                data.isEating = false;
            }
            ++data.tickCounter;
            this.writeData(tile, data);
            return;
        }
        if (tile.getLevel().getRandom().nextInt(60) == 0) {
            Frog frog = (Frog)this.entityFromJar(tile);
            List livingEntities = frog.level.getEntitiesOfClass(LivingEntity.class, new AABB(tile.getBlockPos()).inflate(2.0), Frog::canEat);
            if (livingEntities.isEmpty()) {
                return;
            }
            LivingEntity entity = (LivingEntity)livingEntities.get(tile.getLevel().getRandom().nextInt(livingEntities.size()));
            entity.level.playSound(null, (Entity)entity, SoundEvents.FROG_TONGUE, SoundSource.NEUTRAL, 2.0f, 1.0f);
            entity.setDeltaMovement(entity.position().vectorTo(frog.position()).normalize().scale(0.75));
            entity.hasImpulse = true;
            data.position = entity.position();
            data.tickCounter = 0;
            data.isEating = true;
            data.entityId = entity.getId();
            this.writeData(tile, data);
        }
    }

    public void writeData(MobJarTile tile, ExtraData data) {
        CompoundTag tag = new CompoundTag();
        data.writeToNBT(tag);
        tile.setExtraDataTag(tag);
    }

    public static class ExtraData
    extends AbstractData {
        public Vec3 position;
        public int tickCounter;
        public boolean isEating;
        public int entityId;

        public ExtraData(CompoundTag tag) {
            super(tag);
            this.position = NBTUtil.getVec(tag, "position");
            this.tickCounter = tag.getInt("tickCounter");
            this.isEating = tag.getBoolean("isEating");
            this.entityId = tag.getInt("entityId");
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            NBTUtil.storeVec(tag, "position", this.position);
            tag.putInt("tickCounter", this.tickCounter);
            tag.putBoolean("isEating", this.isEating);
            tag.putInt("entityId", this.entityId);
        }
    }
}

