/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.WallProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.LingerTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityLingeringSpell
extends EntityProjectileSpell {
    public static final EntityDataAccessor<Integer> ACCELERATES = SynchedEntityData.defineId(EntityLingeringSpell.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> AOE = SynchedEntityData.defineId(EntityLingeringSpell.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> LANDED = SynchedEntityData.defineId(EntityLingeringSpell.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SENSITIVE = SynchedEntityData.defineId(EntityLingeringSpell.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SHOULD_FALL = SynchedEntityData.defineId(EntityLingeringSpell.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public double extendedTime;
    public int maxProcs = 100;
    public int totalProcs;

    public EntityLingeringSpell(EntityType<? extends EntityProjectileSpell> type, Level worldIn) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.LINGER_SPELL.get()), worldIn);
    }

    public EntityLingeringSpell(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.LINGER_SPELL.get()), worldIn, x, y, z);
    }

    public EntityLingeringSpell(Level worldIn, LivingEntity shooter) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.LINGER_SPELL.get()), worldIn, shooter);
    }

    public void setAccelerates(int accelerates) {
        this.entityData.set(ACCELERATES, (Object)accelerates);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            boolean isOnGround = this.level.getBlockState(this.blockPosition()).blocksMotion();
            this.setLanded(isOnGround);
        }
        super.tick();
        this.castSpells();
    }

    @Override
    public void traceAnyHit(@Nullable HitResult raytraceresult, Vec3 thisPosition, Vec3 nextPosition) {
    }

    @Override
    public void tickNextPosition() {
        if (!this.shouldFall()) {
            return;
        }
        if (!this.getLanded()) {
            this.setDeltaMovement(0.0, -0.2, 0.0);
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        super.tickNextPosition();
    }

    @Override
    public void buildEmitters() {
        TimelineMap timelineMap = this.resolver().spell.particleTimeline();
        LingerTimeline projectileTimeline = (LingerTimeline)timelineMap.get((IParticleTimelineType)ParticleTimelineRegistry.LINGER_TIMELINE.get());
        TimelineEntryData trailConfig = projectileTimeline.trailEffect;
        TimelineEntryData resolveConfig = projectileTimeline.onResolvingEffect;
        this.tickEmitter = new ParticleEmitter(() -> this.position().add(0.0, 0.2, 0.0), () -> ((EntityLingeringSpell)this).getRotationVector(), trailConfig);
        this.resolveEmitter = new ParticleEmitter(() -> this.position, () -> ((EntityLingeringSpell)this).getRotationVector(), resolveConfig);
        PropertyParticleOptions propertyParticleOptions = this.tickEmitter.particleOptions;
        if (propertyParticleOptions instanceof PropertyParticleOptions) {
            PropertyParticleOptions propertyParticleOptions2 = propertyParticleOptions;
            propertyParticleOptions2.map.set((IPropertyType)ParticlePropertyRegistry.WALL_PROPERTY.get(), new WallProperty(Math.round(this.getAoe()), 5, 20, this.getDirection()));
        }
        this.resolveSound = projectileTimeline.resolveSound.sound;
    }

    public void castSpells() {
        float aoe = this.getAoe();
        int flatAoe = Math.round(aoe);
        if (this.age % Math.max(1, 20 - 2 * this.getAccelerates()) == 0) {
            if (this.isSensitive()) {
                for (BlockPos p : BlockPos.betweenClosed((BlockPos)this.blockPosition().east(flatAoe).north(flatAoe), (BlockPos)this.blockPosition().west(flatAoe).south(flatAoe))) {
                    p = p.immutable();
                    if (!this.level.isClientSide) {
                        this.resolver().getNewResolver(this.resolver().spellContext.clone().makeChildContext()).onResolveEffect(this.level, (HitResult)new BlockHitResult(new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ()), Direction.UP, p, false));
                        continue;
                    }
                    this.resolveEmitter.setPositionOffset(p.subtract((Vec3i)this.getOnPos()).getCenter());
                    this.resolveEmitter.tick(this.level);
                }
                if (!this.level.isClientSide) {
                    this.resolveSound.playSound(this.level, this.getX(), this.getY(), this.getZ());
                }
            } else {
                int i = 0;
                for (Entity entity : this.level.getEntities(null, new AABB(this.blockPosition()).inflate((double)this.getAoe()))) {
                    if (entity.equals((Object)this) || entity.getType().is(EntityTags.LINGERING_BLACKLIST)) continue;
                    if (!this.level.isClientSide) {
                        this.resolver().getNewResolver(this.resolver().spellContext.clone().makeChildContext()).onResolveEffect(this.level, (HitResult)new EntityHitResult(entity));
                        this.resolveSound.playSound(this.level, this.getX(), this.getY(), this.getZ());
                    } else {
                        this.resolveEmitter.setPositionOffset(entity.position.subtract(this.position));
                        this.resolveEmitter.tick(this.level);
                    }
                    if (++i <= 5) continue;
                    break;
                }
                this.totalProcs += i;
                if (this.totalProcs >= this.maxProcs) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    @Override
    public int getExpirationTime() {
        return (int)(70.0 + this.extendedTime * 20.0);
    }

    @Override
    public int getParticleDelay() {
        return 0;
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)ModEntities.LINGER_SPELL.get();
    }

    @Override
    protected void onHit(HitResult result) {
        if (!this.level.isClientSide && result instanceof BlockHitResult && !this.isRemoved()) {
            BlockState state = this.level.getBlockState(((BlockHitResult)result).getBlockPos());
            if (state.is(BlockTags.PORTALS)) {
                state.entityInside(this.level, ((BlockHitResult)result).getBlockPos(), (Entity)this);
                return;
            }
            this.setLanded(true);
        }
    }

    public int getAccelerates() {
        return (Integer)this.entityData.get(ACCELERATES);
    }

    public void setAoe(float aoe) {
        this.entityData.set(AOE, (Object)Float.valueOf(aoe));
    }

    public float getAoe() {
        return (float)(this.isSensitive() ? 1 : 3) + ((Float)this.entityData.get(AOE)).floatValue();
    }

    public void setLanded(boolean landed) {
        this.entityData.set(LANDED, (Object)landed);
    }

    public boolean getLanded() {
        return (Boolean)this.entityData.get(LANDED);
    }

    public void setSensitive(boolean sensitive) {
        this.entityData.set(SENSITIVE, (Object)sensitive);
    }

    public boolean isSensitive() {
        return (Boolean)this.entityData.get(SENSITIVE);
    }

    public void setShouldFall(boolean shouldFall) {
        this.entityData.set(SHOULD_FALL, (Object)shouldFall);
    }

    public boolean shouldFall() {
        return (Boolean)this.entityData.get(SHOULD_FALL);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ACCELERATES, (Object)0);
        pBuilder.define(AOE, (Object)Float.valueOf(0.0f));
        pBuilder.define(LANDED, (Object)false);
        pBuilder.define(SENSITIVE, (Object)false);
        pBuilder.define(SHOULD_FALL, (Object)true);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("sensitive", this.isSensitive());
        tag.putBoolean("shouldFall", this.shouldFall());
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        this.setSensitive(compound.getBoolean("sensitive"));
        this.setShouldFall(compound.getBoolean("shouldFall"));
    }
}

