/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.documentation;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.nuggets.client.gui.ItemButton;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;

public class AugmentIcon
extends ItemButton {
    AbstractSpellPart parent;

    public AugmentIcon(AbstractSpellPart parent, int x, int y, int w, int h, @NotNull Component text, Button.OnPress onPress, Ingredient ingredient, Screen screen) {
        super(x, y, w, h, text, onPress, ingredient, screen);
        this.parent = parent;
    }

    public AugmentIcon(AbstractSpellPart parent, int x, int y, int w, int h, @NotNull Component text, Button.OnPress onPress, ItemStack stack, Screen screen) {
        super(x, y, w, h, text, onPress, stack, screen);
        this.parent = parent;
    }

    public void gatherTooltips(GuiGraphics graphics, int mouseX, int mouseY, List<Component> tooltip) {
        this.gatherTooltips(tooltip);
    }

    public void gatherTooltips(List<Component> tooltip) {
        Item item;
        if (this.parent != null && (item = this.ingredient.getItems()[0].getItem()) instanceof Glyph) {
            Glyph glyph = (Glyph)item;
            AbstractSpellPart spellPart = glyph.spellPart;
            tooltip.add((Component)Component.translatable((String)spellPart.getLocalizationKey()));
            Component augmentDescription = this.parent.augmentDescriptions.get(spellPart);
            if (augmentDescription != null) {
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.augmenting", (Object[])new Object[]{this.parent.getLocaleName()}));
                tooltip.add((Component)augmentDescription.copy().withStyle(ChatFormatting.GOLD));
            }
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.ars_nouveau.glyph_level", (Object[])new Object[]{spellPart.getConfigTier().value}).setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
                tooltip.add(spellPart.getBookDescLang());
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getKey().getDisplayName()}));
                String modName = ModList.get().getModContainerById(spellPart.getRegistryName().getNamespace()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(spellPart.getRegistryName().getNamespace());
                tooltip.add((Component)Component.literal((String)modName).withStyle(ChatFormatting.BLUE));
            }
        }
    }
}

