/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.client.gui.GuiUtils;
import com.hollingsworth.nuggets.client.gui.ITooltipRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class ModdedScreen
extends Screen {
    public int maxScale;
    public float scaleFactor;

    public ModdedScreen(Component titleIn) {
        super(titleIn);
    }

    public void init() {
        super.init();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0f;
    }

    public void drawTooltip(GuiGraphics stack, int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.collectTooltips(mouseX, mouseY, tooltip);
        Optional<TooltipComponent> image = Optional.ofNullable(this.collectComponent(mouseX, mouseY));
        if (image.isPresent() && tooltip.isEmpty()) {
            tooltip.add((Component)Component.empty());
        }
        stack.renderTooltip(this.font, tooltip, image, mouseX, mouseY);
    }

    public void collectTooltips(int mouseX, int mouseY, List<Component> tooltip) {
        for (Renderable renderable : this.renderables) {
            AbstractWidget widget;
            if (!(renderable instanceof AbstractWidget) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget = (AbstractWidget)renderable) || !widget.visible) continue;
            if (renderable instanceof ITooltipProvider) {
                ITooltipProvider tooltipProvider = (ITooltipProvider)renderable;
                tooltipProvider.getTooltip(tooltip);
                break;
            }
            if (!(renderable instanceof ITooltipRenderer)) break;
            ITooltipRenderer nuggetProvider = (ITooltipRenderer)renderable;
            nuggetProvider.gatherTooltips(tooltip);
            break;
        }
    }

    protected TooltipComponent collectComponent(int mouseX, int mouseY) {
        return null;
    }

    @Nullable
    public Renderable getHoveredRenderable(int mouseX, int mouseY) {
        for (Renderable renderable : this.renderables) {
            AbstractWidget widget;
            if (!(renderable instanceof AbstractWidget) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget = (AbstractWidget)renderable)) continue;
            return renderable;
        }
        return null;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private int getMaxAllowedScale() {
        return this.minecraft.getWindow().calculateScale(0, this.minecraft.isEnforceUnicode());
    }
}

