/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.client.gui.Color;

public class HSLColor {
    private int red;
    private int green;
    private int blue;
    private double hue;
    private double saturation;
    private double lightness;
    private double opacity;
    private String hex;

    public Color toColor() {
        return new Color(this.toInt());
    }

    public static HSLColor rgb(int red, int green, int blue) {
        return HSLColor.rgb(red, green, blue, 1.0);
    }

    public static HSLColor rgb(int red, int green, int blue, double opacity) {
        HSLColor color = new HSLColor();
        color.red = red;
        color.green = green;
        color.blue = blue;
        color.opacity = opacity;
        double r = (double)red / 255.0;
        double g = (double)green / 255.0;
        double b = (double)blue / 255.0;
        double max = Math.max(Math.max(r, g), b);
        double min = Math.min(Math.min(r, g), b);
        double delta = max - min;
        color.lightness = (max + min) / 2.0;
        double d = color.saturation = delta == 0.0 ? 0.0 : delta / (1.0 - Math.abs(2.0 * color.lightness - 1.0));
        if (delta == 0.0) {
            color.hue = 0.0;
        } else if (max == r) {
            color.hue = 60.0 * ((g - b) / delta + 0.0);
        } else if (max == g) {
            color.hue = 60.0 * ((b - r) / delta + 2.0);
        } else if (max == b) {
            color.hue = 60.0 * ((r - g) / delta + 4.0);
        }
        color.hue = color.hue < 0.0 ? color.hue + 360.0 : Math.min(color.hue, 360.0);
        color.hex = String.format("#%02x%02x%02x", red, green, blue);
        return color;
    }

    public static HSLColor hsl(double hue, double saturation, double lightness) {
        return HSLColor.hsl(hue, saturation, lightness, 1.0);
    }

    public static HSLColor hsl(double hue, double saturation, double lightness, double opacity) {
        double _c = (1.0 - Math.abs(2.0 * lightness - 1.0)) * saturation;
        double _h = hue / 60.0;
        double _x = _c * (1.0 - Math.abs(_h % 2.0 - 1.0));
        double[] _rgb = new double[]{0.0, 0.0, 0.0};
        if (_h >= 0.0 && _h < 1.0) {
            _rgb = new double[]{_c, _x, 0.0};
        } else if (_h >= 1.0 && _h < 2.0) {
            _rgb = new double[]{_x, _c, 0.0};
        } else if (_h >= 2.0 && _h < 3.0) {
            _rgb = new double[]{0.0, _c, _x};
        } else if (_h >= 3.0 && _h < 4.0) {
            _rgb = new double[]{0.0, _x, _c};
        } else if (_h >= 4.0 && _h < 5.0) {
            _rgb = new double[]{_x, 0.0, _c};
        } else if (_h >= 5.0 && _h < 6.0) {
            _rgb = new double[]{_c, 0.0, _x};
        }
        double _m = lightness - _c / 2.0;
        int red = (int)((_rgb[0] + _m) * 255.0);
        int green = (int)((_rgb[1] + _m) * 255.0);
        int blue = (int)((_rgb[2] + _m) * 255.0);
        HSLColor color = HSLColor.rgb(red, green, blue);
        color.opacity = opacity;
        color.hue = hue;
        color.saturation = saturation;
        color.lightness = lightness;
        return color;
    }

    public int toInt() {
        return (((int)(this.opacity * 255.0) & 0xFF) << 24) + ((this.red & 0xFF) << 16) + ((this.green & 0xFF) << 8) + (this.blue & 0xFF);
    }

    public double getHue() {
        return this.hue;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public double getLightness() {
        return this.lightness;
    }

    public double getOpacity() {
        return this.opacity;
    }
}

