/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.Level;

public class LevelEntityMap {
    public Map<String, Set<UUID>> entityMap = new ConcurrentHashMap<String, Set<UUID>>();

    public void addEntity(Level level, UUID uuid) {
        this.addEntity(level.dimension().location().toString(), uuid);
    }

    public void addEntity(String key, UUID uuid) {
        if (!this.entityMap.containsKey(key)) {
            this.entityMap.put(key, ConcurrentHashMap.newKeySet());
        }
        this.entityMap.get(key).add(uuid);
    }

    public boolean containsEntity(Level level, UUID uuid) {
        return this.containsEntity(level.dimension().location().toString(), uuid);
    }

    public boolean containsEntity(String key, UUID uuid) {
        if (!this.entityMap.containsKey(key)) {
            return false;
        }
        return this.entityMap.get(key).contains(uuid);
    }

    public void removeEntity(Level level, UUID uuid) {
        this.removeEntity(level.dimension().location().toString(), uuid);
    }

    public void removeEntity(String key, UUID uuid) {
        if (!this.entityMap.containsKey(key)) {
            return;
        }
        this.entityMap.get(key).remove(uuid);
    }

    public Set<UUID> getEntities(Level level) {
        return this.getEntities(level.dimension().location().toString());
    }

    public Set<UUID> getEntities(String key) {
        if (!this.entityMap.containsKey(key)) {
            return ConcurrentHashMap.newKeySet();
        }
        return this.entityMap.get(key);
    }
}

