/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SpeedProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticleMotionRegistry;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SpiralMotion
extends ParticleMotion {
    public static MapCodec<SpiralMotion> CODEC = SpiralMotion.buildPropCodec(SpiralMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, SpiralMotion> STREAM = SpiralMotion.buildStreamCodec(SpiralMotion::new);

    public SpiralMotion(PropMap propMap) {
        super(propMap);
    }

    @Override
    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ParticleMotionRegistry.SPIRAL_TYPE.get();
    }

    @Override
    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        ParticleDensityProperty density = this.getDensity(particleOptions, 100, 0.3f);
        double spiralRadius = density.radius();
        int totalParticles = this.getNumParticles(density.density());
        for (int step = 0; step <= totalParticles; ++step) {
            double t = (double)step / (double)totalParticles;
            double interpolatedX = prevX + t * (x - prevX);
            double interpolatedY = prevY + t * (y - prevY);
            double interpolatedZ = prevZ + t * (z - prevZ);
            double angle = (double)this.emitter.age + t;
            float localX = (float)(Math.cos(angle) * spiralRadius);
            float localZ = 0.0f;
            float localY = (float)(Math.sin(angle) * spiralRadius);
            Vector3f localPos = this.toEmitterSpace((float)interpolatedX, (float)interpolatedY, (float)interpolatedZ, localX, localY, localZ);
            Vec3 speed = this.randomSpeed(particleOptions);
            level.addAlwaysVisibleParticle((ParticleOptions)particleOptions, true, (double)localPos.x, (double)localPos.y, (double)localPos.z, speed.x, speed.y, speed.z);
        }
    }

    @Override
    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing(new ParticleTypeProperty()), propMap.createIfMissing(new ParticleDensityProperty(100, (double)0.3f, ParticleMotion.SpawnType.SPHERE).maxDensity(200).minDensity(20).densityStepSize(5).supportsShapes(false).supportsRadius(true)), propMap.createIfMissing(new SpeedProperty().yRange(-0.05, 0.05).xzRange(-0.05, 0.05)));
    }
}

