/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.client;

import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.item.ICosmeticItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.util.RenderUtil;

public class CosmeticRenderUtil {
    public static <T extends LivingEntity> void renderCosmetic(GeoBone bone, PoseStack matrix, MultiBufferSource buffer, T entity, int packedLightIn) {
        ItemStack stack = ((IDecoratable)entity).getCosmeticItem();
        Item item = stack.getItem();
        if (!(item instanceof ICosmeticItem)) {
            return;
        }
        ICosmeticItem cosmetic = (ICosmeticItem)item;
        matrix.pushPose();
        RenderUtil.translateToPivotPoint((PoseStack)matrix, (GeoBone)bone);
        RenderUtil.rotateMatrixAroundBone((PoseStack)matrix, (GeoBone)bone);
        RenderUtil.translateMatrixToBone((PoseStack)matrix, (GeoBone)bone);
        Vec3 translations = cosmetic.getTranslations(entity);
        Vec3 scaling = cosmetic.getScaling(entity);
        matrix.translate(translations.x, translations.y, translations.z);
        matrix.scale((float)scaling.x, (float)scaling.y, (float)scaling.z);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, cosmetic.getTransformType(), packedLightIn, OverlayTexture.NO_OVERLAY, matrix, buffer, entity.level, (int)entity.getOnPos().asLong());
        matrix.popPose();
    }
}

