/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.glyphs;

import com.alexthw.ars_hex.ArsHex;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.sammy.malum.registry.common.MalumDamageTypes;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectSoulShatter
extends AbstractEffect
implements IDamageEffect {
    public static final EffectSoulShatter INSTANCE = new EffectSoulShatter();

    public EffectSoulShatter() {
        super(ArsHex.prefix("glyph_soul_shatter"), "Soul Shatter");
    }

    public String getBookDescription() {
        return "Shatter the enemy soul, damaging it with the chance of releasing the spirits inside.";
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (!(rayTraceResult.getEntity() instanceof ItemEntity)) {
            double damage = (Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
            this.attemptDamage(world, shooter, spellStats, spellContext, resolver, rayTraceResult.getEntity(), this.buildDamageSource(world, shooter), (float)damage);
        }
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        return DamageUtil.source((LevelAccessor)world, (ResourceKey)MalumDamageTypes.VOODOO, (Entity)ANFakePlayer.getOrFakePlayer((ServerLevel)((ServerLevel)world), (LivingEntity)shooter));
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 5.0);
        this.addAmpConfig(builder, 3.0);
    }

    public int getDefaultManaCost() {
        return 30;
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE});
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        if (ModList.get().isLoaded("ars_elemental")) {
            return Set.of(SpellSchools.NECROMANCY);
        }
        return super.getSchools();
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }
}

