/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_hex.datagen;

import com.alexthw.ars_hex.datagen.Setup;
import com.alexthw.ars_hex.glyphs.EffectSoulShatter;
import com.alexthw.ars_hex.malum.MalumCompat;
import com.alexthw.ars_hex.malum.perks.MagicProficencyPerk;
import com.alexthw.ars_hex.malum.perks.SoulWardPerk;
import com.alexthw.ars_hex.malum.perks.SpiritSpoilsPerk;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.RecipeDatagen;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.sammy.malum.registry.common.item.MalumItems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ArsProviders {
    static String root = "ars_hex";

    private static JsonElement wrapModCondition(JsonElement element, String modid) {
        JsonObject condition = new JsonObject();
        condition.addProperty("type", "neoforge:mod_loaded");
        condition.addProperty("modid", modid);
        JsonArray array = new JsonArray();
        array.add((JsonElement)condition);
        element.getAsJsonObject().add("neoforge:conditions", (JsonElement)array);
        return element;
    }

    public static class ImbuementProvider
    extends ImbuementRecipeProvider {
        public ImbuementProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
            this.collectJsons(pOutput);
            ArrayList futures = new ArrayList();
            return Setup.provider.thenCompose(registry -> {
                for (ImbuementRecipe g : this.recipes) {
                    Path path = this.getRecipePath(this.output, g.id.getPath());
                    futures.add(DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)registry, (Codec)ImbuementRecipe.CODEC, (Object)g, (Path)path));
                }
                return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            });
        }

        public void collectJsons(CachedOutput cache) {
        }

        protected Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        @NotNull
        public String getName() {
            return "Example Imbuement";
        }
    }

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            this.recipes.add(this.builder().withReagent((ItemLike)MalumItems.SOUL_STAINED_STEEL_SCYTHE.get()).withPedestalItem(Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem(RecipeDatagen.SOURCE_GEM_BLOCK).withPedestalItem(3, RecipeDatagen.ARCHWOOD_LOG).withResult((ItemLike)MalumCompat.ENCHANTER_SCYTHE.get()).keepNbtOfReagent(true).build());
            this.recipes.add(this.builder().withResult((ItemLike)this.getPerkItem(SoulWardPerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem((ItemLike)MalumItems.RUNE_OF_REINFORCEMENT.get()).withPedestalItem(2, (ItemLike)MalumItems.REFINED_SOULSTONE.get()).withPedestalItem(2, (ItemLike)MalumItems.SOUL_STAINED_STEEL_PLATING.get()).withPedestalItem((ItemLike)MalumItems.ARCANE_SPIRIT.get()).build());
            this.recipes.add(this.builder().withResult((ItemLike)this.getPerkItem(SpiritSpoilsPerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem((ItemLike)MalumItems.RING_OF_ESOTERIC_SPOILS.get()).withPedestalItem((ItemLike)MalumItems.REFINED_SOULSTONE.get()).withPedestalItem((ItemLike)MalumItems.ARCANE_SPIRIT.get()).withPedestalItem((ItemLike)MalumItems.WICKED_SPIRIT.get()).withPedestalItem((ItemLike)MalumItems.ELDRITCH_SPIRIT.get()).build());
            this.recipes.add(this.builder().withResult((ItemLike)this.getPerkItem(MagicProficencyPerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem(2, (ItemLike)MalumItems.REFINED_SOULSTONE.get()).withPedestalItem(2, (ItemLike)MalumItems.SOULWOVEN_SILK.get()).withPedestalItem(2, (ItemLike)MalumItems.EARTHEN_SPIRIT.get()).withPedestalItem(2, (ItemLike)MalumItems.AERIAL_SPIRIT.get()).build());
            Path output = this.generator.getPackOutput().getOutputFolder();
            for (ApparatusRecipeBuilder.RecipeWrapper g : this.recipes) {
                if (g == null) continue;
                Path path = EnchantingAppProvider.getRecipePath(output, g.id().getPath());
                JsonElement wrapped = ArsProviders.wrapModCondition(g.serialize(), "malum");
                this.saveStable(cache, wrapped, path);
            }
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        @NotNull
        public String getName() {
            return "Example Apparatus";
        }
    }

    public static class GlyphProvider
    extends GlyphRecipeProvider {
        public GlyphProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            Path output = this.generator.getPackOutput().getOutputFolder();
            this.add(this.get((AbstractSpellPart)EffectSoulShatter.INSTANCE).withItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withItem((ItemLike)MalumItems.WICKED_SPIRIT.get()).withItem((ItemLike)MalumItems.SOUL_STAINED_STEEL_SWORD.get()));
            for (GlyphRecipe recipe : this.recipes) {
                Path path = GlyphProvider.getScribeGlyphPath(output, recipe.output.getItem());
                JsonElement wrapped = ArsProviders.wrapModCondition((JsonElement)GlyphRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).getOrThrow(), "malum");
                this.saveStable(cache, wrapped, path);
            }
        }

        protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
            return pathIn.resolve("data/" + root + "/recipe/" + RegistryHelper.getRegistryName((Item)glyph).getPath() + ".json");
        }

        @NotNull
        public String getName() {
            return "Example Glyph Recipes";
        }
    }
}

