/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.recipe;

import alexthw.ars_elemental.common.components.ElementProtectionFlag;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NetheriteUpgradeRecipe
extends EnchantingApparatusRecipe {
    public NetheriteUpgradeRecipe(Ingredient reagent, List<Ingredient> stacks, int cost) {
        super(reagent, ItemStack.EMPTY, stacks, cost, true);
    }

    public boolean excludeJei() {
        return true;
    }

    public boolean matches(ApparatusRecipeInput input, Level level) {
        ElementProtectionFlag flag = (ElementProtectionFlag)input.catalyst().get(ModRegistry.P4E);
        return super.matches(input, level) && (flag == null || !flag.flag());
    }

    @NotNull
    public ItemStack assemble(ApparatusRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_346030_) {
        ItemStack temp = input.catalyst().copy();
        temp.set(ModRegistry.P4E, (Object)new ElementProtectionFlag(true));
        return temp;
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRegistry.NETHERITE_UP.get();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.NETHERITE_UP_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<NetheriteUpgradeRecipe> {
        public static MapCodec<NetheriteUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("reagent").forGetter(EnchantingApparatusRecipe::reagent), (App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost)).apply((Applicative)instance, NetheriteUpgradeRecipe::new));
        public static StreamCodec<RegistryFriendlyByteBuf, NetheriteUpgradeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, EnchantingApparatusRecipe::reagent, (StreamCodec)ANCodecs.INGREDIENT_LIST_STREAM, EnchantingApparatusRecipe::pedestalItems, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantingApparatusRecipe::sourceCost, NetheriteUpgradeRecipe::new);

        @NotNull
        public MapCodec<NetheriteUpgradeRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, NetheriteUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

