/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.mob_effects;

import alexthw.ars_elemental.registry.ModPotions;
import com.alexthw.sauce.util.EntityCarryMEI;
import java.util.Set;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import org.jetbrains.annotations.NotNull;

public class LifeLinkEffect
extends MobEffect {
    public LifeLinkEffect() {
        super(MobEffectCategory.NEUTRAL, 1);
        NeoForge.EVENT_BUS.addListener(this::healForHeal);
        NeoForge.EVENT_BUS.addListener(this::hurtForHurt);
    }

    public void fillEffectCures(@NotNull Set<EffectCure> cures, @NotNull MobEffectInstance effectInstance) {
    }

    public void healForHeal(LivingHealEvent event) {
        EntityCarryMEI mei;
        MobEffectInstance instance;
        if (event.getEntity().hasEffect(ModPotions.LIFE_LINK) && (instance = event.getEntity().getEffect(ModPotions.LIFE_LINK)) instanceof EntityCarryMEI && (mei = (EntityCarryMEI)instance).getTarget() == event.getEntity()) {
            if (mei.getOwner() != null && mei.getOwner().isAlive()) {
                float shared = event.getAmount() / 2.0f;
                mei.getOwner().heal(shared);
                event.setAmount(shared);
            } else {
                event.getEntity().removeEffect(ModPotions.LIFE_LINK);
            }
        }
    }

    public void hurtForHurt(LivingDamageEvent.Pre event) {
        EntityCarryMEI mei;
        MobEffectInstance instance;
        if (!event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) && event.getEntity().hasEffect(ModPotions.LIFE_LINK) && (instance = event.getEntity().getEffect(ModPotions.LIFE_LINK)) instanceof EntityCarryMEI && (mei = (EntityCarryMEI)instance).getOwner() == event.getEntity()) {
            if (mei.getTarget() != null && mei.getTarget().isAlive()) {
                float shared = event.getNewDamage() / 2.0f;
                mei.getTarget().hurt(event.getSource(), shared);
                event.setNewDamage(shared);
            } else {
                event.getEntity().removeEffect(ModPotions.LIFE_LINK);
            }
        }
    }
}

