/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectNullify
extends ElementalAbstractEffect {
    public static final EffectNullify INSTANCE = new EffectNullify();

    public EffectNullify() {
        super("nullify_defense", "Nullify Defense");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.invulnerableTime = 0;
        }
    }

    protected int getDefaultManaCost() {
        return 1000;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return Set.of();
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return Set.of(SpellSchools.NECROMANCY);
    }

    public String getBookDescription() {
        return "Nullifies the target's innate immunity after taking damage, making it vulnerable to damage again.";
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }
}

