/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.ai;

import alexthw.ars_elemental.common.entity.FlashjackEntity;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HijackTurretGoal
extends Goal {
    private final FlashjackEntity mob;
    private final float detectionRange;
    int cooldown = 0;

    public HijackTurretGoal(FlashjackEntity mob, float detectionRange) {
        this.mob = mob;
        this.detectionRange = detectionRange;
    }

    public boolean canUse() {
        return this.mob != null && this.mob.isTamed() && this.mob.getTarget() != null && this.mob.getTarget().isAlive();
    }

    public void tick() {
        super.tick();
        if (this.mob.getTarget() == null) {
            return;
        }
        this.mob.getTarget().addEffect(new MobEffectInstance(MobEffects.GLOWING, 40));
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        Networking.sendToNearbyClient((Level)this.mob.level, (Entity)this.mob, (CustomPacketPayload)new PacketAnimEntity(this.mob.getId(), 0));
        List<BlockPos> turrets = this.mob.getTurrets();
        if (!turrets.isEmpty()) {
            for (BlockPos turretPos : turrets) {
                BlockEntity blockEntity = this.mob.level().getBlockEntity(turretPos);
                if (!(blockEntity instanceof RotatingTurretTile)) continue;
                RotatingTurretTile turret = (RotatingTurretTile)blockEntity;
                turret.aim(this.mob.getTarget().blockPosition(), (Player)ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)this.mob.level())));
                turret.shootSpell();
            }
            this.cooldown += 20;
        }
        List walkers = this.mob.level().getEntitiesOfClass(WealdWalker.class, this.mob.getBoundingBox().inflate((double)this.detectionRange), LivingEntity::isAlive);
        for (WealdWalker walker : walkers) {
            walker.setTarget(this.mob.getTarget());
        }
    }
}

