/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.mixin;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.capability.PlayerAffinityDataProvider;
import com.github.ars_affinity.event.SchoolAffinityPointAllocatedEvent;
import com.github.ars_affinity.perk.PointCalculationHelper;
import com.github.ars_affinity.school.SchoolRelationshipHelper;
import com.github.ars_affinity.util.GlyphBlacklistHelper;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpellResolver.class}, remap=false)
public abstract class SpellTrackingMixin {
    @Shadow(remap=false)
    public SpellContext spellContext;

    @Shadow(remap=false)
    public abstract SpellStats getCastStats();

    @Inject(method={"onResolveEffect"}, at={@At(value="HEAD")})
    private void trackSpellResolution(Level world, HitResult result, CallbackInfo ci) {
        if (world.isClientSide()) {
            return;
        }
        try {
            SpellContext spellContext = this.spellContext;
            if (spellContext == null) {
                return;
            }
            IWrappedCaster caster = spellContext.getCaster();
            if (!(caster instanceof PlayerCaster)) {
                return;
            }
            Spell spell = spellContext.getSpell();
            if (spell == null) {
                return;
            }
            if (spell.recipe() == null) {
                return;
            }
            boolean hasElements = false;
            Iterator iterator = spell.recipe().iterator();
            if (iterator.hasNext()) {
                AbstractSpellPart ignored = (AbstractSpellPart)iterator.next();
                hasElements = true;
            }
            if (!hasElements) {
                return;
            }
            SpellStats spellStats = this.getCastStats();
            this.trackSpellUsage((PlayerCaster)caster, spell, spellStats, world);
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Error tracking spell resolution for mastery: {}", (Object)e.getMessage());
        }
    }

    private void trackSpellUsage(PlayerCaster caster, Spell spell, SpellStats stats, Level world) {
        try {
            Iterable recipe = spell.recipe();
            if (recipe == null) {
                return;
            }
            ArrayList<AbstractAugment> currentAugments = new ArrayList<AbstractAugment>();
            AbstractSpellPart currentBase = null;
            Iterator iterator = recipe.iterator();
            block7: while (iterator.hasNext()) {
                AbstractSpellPart glyph;
                AbstractSpellPart abstractSpellPart = glyph = (AbstractSpellPart)iterator.next();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractCastMethod.class, AbstractAugment.class}, (Object)abstractSpellPart, n)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        AbstractCastMethod ignored = (AbstractCastMethod)abstractSpellPart;
                        continue block7;
                    }
                    case 1: {
                        AbstractAugment augment = (AbstractAugment)abstractSpellPart;
                        currentAugments.add(augment);
                        continue block7;
                    }
                }
                if (currentBase != null) {
                    this.trackSpellSegment(caster, currentBase, new ArrayList<AbstractAugment>(currentAugments), stats, world);
                    currentAugments.clear();
                }
                currentBase = glyph;
            }
            if (currentBase != null) {
                this.trackSpellSegment(caster, currentBase, currentAugments, stats, world);
            }
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Error accessing spell recipe: {}", (Object)e.getMessage());
        }
    }

    private void trackSpellSegment(PlayerCaster caster, AbstractSpellPart glyph, List<AbstractAugment> augments, SpellStats stats, Level world) {
        Player player = caster.player;
        if (player == null) {
            return;
        }
        this.trackSchoolProgress(player, glyph, augments);
    }

    private void trackSchoolProgress(Player player, AbstractSpellPart glyph, List<AbstractAugment> augments) {
        if (GlyphBlacklistHelper.isGlyphBlacklisted(glyph)) {
            ArsAffinity.LOGGER.info("Glyph {} is blacklisted - skipping affinity progress tracking", (Object)(glyph.getRegistryName() != null ? glyph.getRegistryName().toString() : "unknown"));
            return;
        }
        float manaCost = glyph.getCastingCost();
        List schools = glyph.spellSchools;
        if (schools == null || schools.isEmpty()) {
            return;
        }
        PlayerAffinityData affinityData = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (affinityData == null) {
            ArsAffinity.LOGGER.warn("Could not get affinity data for player: {}", (Object)player.getName().getString());
            return;
        }
        float distributedCost = manaCost / (float)schools.size();
        boolean hasChanges = false;
        for (SpellSchool school : schools) {
            int totalPointsAcrossAllSchools;
            float currentPercentage = affinityData.getSchoolPercentage(school);
            float percentageIncrease = PointCalculationHelper.calculatePercentageIncrease(distributedCost, currentPercentage, totalPointsAcrossAllSchools = affinityData.getTotalPointsAcrossAllSchools());
            if (!(percentageIncrease > 0.0f)) continue;
            int pointsAwarded = affinityData.addSchoolProgress(school, percentageIncrease);
            if (pointsAwarded > 0) {
                SchoolAffinityPointAllocatedEvent event = new SchoolAffinityPointAllocatedEvent(player, school, pointsAwarded, affinityData.getSchoolPoints(school));
                NeoForge.EVENT_BUS.post((Event)event);
            }
            hasChanges = true;
        }
        if (hasChanges) {
            StringBuilder affinityLog = new StringBuilder();
            affinityLog.append("Affinity Points: ");
            for (SpellSchool affinitySchool : SchoolRelationshipHelper.ALL_SCHOOLS) {
                int points = affinityData.getSchoolPoints(affinitySchool);
                affinityLog.append(String.format("%s: %d pts", affinitySchool.getTextComponent().getString(), points));
                if (affinitySchool == SchoolRelationshipHelper.ALL_SCHOOLS[SchoolRelationshipHelper.ALL_SCHOOLS.length - 1]) continue;
                affinityLog.append(", ");
            }
            ArsAffinity.LOGGER.info("Affinity Points: {}", (Object)affinityLog.toString());
            PlayerAffinityDataHelper.savePlayerData(player);
            PlayerAffinityDataProvider.syncToClient(player);
        }
    }
}

