/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;

public class SpellAmplificationEvents {
    private static final Map<UUID, Float> playerHealingAmplification = new HashMap<UUID, Float>();

    @SubscribeEvent
    public static void onSpellCast(SpellCastEvent event) {
        List<AbstractSpellPart> healingEffects;
        IWrappedCaster iWrappedCaster = event.context.getCaster();
        if (!(iWrappedCaster instanceof PlayerCaster)) {
            return;
        }
        PlayerCaster playerCaster = (PlayerCaster)iWrappedCaster;
        Player player = playerCaster.player;
        if (player.level().isClientSide()) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_HEALING_AMPLIFICATION) && (healingEffects = event.spell.unsafeList().stream().filter(part -> part instanceof EffectHeal).toList()).size() > 0) {
            float amount = AffinityPerkHelper.getPerkAmount(player, AffinityPerkType.PASSIVE_HEALING_AMPLIFICATION);
            playerHealingAmplification.put(player.getUUID(), Float.valueOf(amount));
            ArsAffinity.LOGGER.info("Player {} cast healing spell with {}% amplification", (Object)player.getName().getString(), (Object)((int)(amount * 100.0f)));
        }
    }

    @SubscribeEvent
    public static void onSpellResolve(SpellResolveEvent.Post event) {
        IWrappedCaster iWrappedCaster = event.context.getCaster();
        if (!(iWrappedCaster instanceof PlayerCaster)) {
            return;
        }
        PlayerCaster playerCaster = (PlayerCaster)iWrappedCaster;
        Player player = playerCaster.player;
        if (player.level().isClientSide()) {
            return;
        }
        playerHealingAmplification.remove(player.getUUID());
    }

    @SubscribeEvent
    public static void onEffectResolve(EffectResolveEvent.Pre event) {
        Float amplification;
        LivingEntity livingEntity = event.shooter;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        if (event.resolveEffect instanceof EffectHeal && (amplification = playerHealingAmplification.get(player.getUUID())) != null) {
            double currentAmp = event.spellStats.getAmpMultiplier();
            double newAmp = currentAmp + (double)amplification.floatValue();
            event.spellStats.setAmpMultiplier(newAmp);
            ArsAffinity.LOGGER.info("Applied {}% healing amplification to EffectHeal for player {}", (Object)((int)(amplification.floatValue() * 100.0f)), (Object)player.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onEffectResolvePost(EffectResolveEvent.Post event) {
        Float amplification;
        LivingEntity livingEntity = event.shooter;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        if (event.resolveEffect instanceof EffectHeal && (amplification = playerHealingAmplification.get(player.getUUID())) != null && amplification.floatValue() > 0.0f) {
            EntityHitResult entityHit;
            Entity entity;
            Player targetPlayer = null;
            HitResult hitResult = event.rayTraceResult;
            if (hitResult instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)hitResult).getEntity()) instanceof Player) {
                Player hitPlayer;
                targetPlayer = hitPlayer = (Player)entity;
            }
            String healedName = targetPlayer != null ? targetPlayer.getName().getString() : player.getName().getString();
            float reductionPercent = Math.min(1.0f, amplification.floatValue());
            float baseExhaustion = 2.5f;
            float exhaustionToCompensate = baseExhaustion * reductionPercent;
            FoodData foodData = player.getFoodData();
            int currentFood = foodData.getFoodLevel();
            float currentSaturation = foodData.getSaturationLevel();
            float saturationToAdd = exhaustionToCompensate;
            float newSaturation = Math.min((float)currentFood, currentSaturation + saturationToAdd);
            foodData.setSaturation(newSaturation);
            float remainingExhaustion = exhaustionToCompensate - (newSaturation - currentSaturation);
            if (remainingExhaustion > 0.001f) {
                int foodToAdd = (int)Math.ceil(remainingExhaustion / 4.0f);
                int newFood = Math.min(20, currentFood + foodToAdd);
                foodData.setFoodLevel(newFood);
                ArsAffinity.LOGGER.info("Healing Amplification compensated exhaustion for caster {} while healing {}: +{} food, +{} saturation ({}% reduction)", (Object)player.getName().getString(), (Object)healedName, (Object)foodToAdd, (Object)Float.valueOf(saturationToAdd), (Object)((int)(reductionPercent * 100.0f)));
            } else {
                ArsAffinity.LOGGER.info("Healing Amplification compensated exhaustion for caster {} while healing {}: +{} saturation ({}% reduction)", (Object)player.getName().getString(), (Object)healedName, (Object)Float.valueOf(saturationToAdd), (Object)((int)(reductionPercent * 100.0f)));
            }
        }
    }
}

