/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.network;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataProvider;
import com.github.ars_affinity.client.screen.perk.PerkTreeScreen;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SyncPlayerAffinityDataPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<SyncPlayerAffinityDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"sync_player_affinity_data"));
    public static final StreamCodec<FriendlyByteBuf, SyncPlayerAffinityDataPacket> CODEC = StreamCodec.ofMember(SyncPlayerAffinityDataPacket::encode, SyncPlayerAffinityDataPacket::new);
    private final Map<SpellSchool, Integer> schoolPoints;
    private final Map<SpellSchool, Float> schoolPercentages;
    private final CompoundTag serializedData;

    public SyncPlayerAffinityDataPacket(PlayerAffinityData data, Player player) {
        this.schoolPoints = data.getAllSchoolPoints();
        this.schoolPercentages = data.getAllSchoolPercentages();
        this.serializedData = data.serializeNBT((HolderLookup.Provider)player.level().registryAccess());
    }

    public SyncPlayerAffinityDataPacket(FriendlyByteBuf buffer) {
        this.schoolPoints = new HashMap<SpellSchool, Integer>();
        this.schoolPercentages = new HashMap<SpellSchool, Float>();
        int pointsCount = buffer.readInt();
        for (int i = 0; i < pointsCount; ++i) {
            String schoolId = buffer.readUtf();
            int points = buffer.readInt();
            SpellSchool school = SyncPlayerAffinityDataPacket.getSchoolFromId(schoolId);
            if (school == null) continue;
            this.schoolPoints.put(school, points);
        }
        int percentagesCount = buffer.readInt();
        for (int i = 0; i < percentagesCount; ++i) {
            String schoolId = buffer.readUtf();
            float percentage = buffer.readFloat();
            SpellSchool school = SyncPlayerAffinityDataPacket.getSchoolFromId(schoolId);
            if (school == null) continue;
            this.schoolPercentages.put(school, Float.valueOf(percentage));
        }
        this.serializedData = buffer.readNbt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.schoolPoints.size());
        for (Map.Entry<SpellSchool, Integer> entry : this.schoolPoints.entrySet()) {
            buffer.writeUtf(entry.getKey().getId().toString());
            buffer.writeInt(entry.getValue().intValue());
        }
        buffer.writeInt(this.schoolPercentages.size());
        for (Map.Entry<SpellSchool, Number> entry : this.schoolPercentages.entrySet()) {
            buffer.writeUtf(entry.getKey().getId().toString());
            buffer.writeFloat(((Float)entry.getValue()).floatValue());
        }
        buffer.writeNbt((Tag)this.serializedData);
    }

    public void onClientReceived(Minecraft minecraft, Player player) {
        if (player == null) {
            ArsAffinity.LOGGER.warn("Cannot sync affinity data - player is null");
            return;
        }
        PlayerAffinityData clientData = PlayerAffinityDataProvider.getPlayerAffinityData(player);
        if (clientData != null && this.serializedData != null) {
            try {
                clientData.deserializeNBT((HolderLookup.Provider)player.level().registryAccess(), this.serializedData);
                ArsAffinity.LOGGER.info("Successfully synced affinity data to client for player {}", (Object)player.getName().getString());
                minecraft.execute(() -> {
                    Screen patt0$temp = minecraft.screen;
                    if (patt0$temp instanceof PerkTreeScreen) {
                        PerkTreeScreen screen = (PerkTreeScreen)patt0$temp;
                        screen.refreshData();
                    }
                });
            }
            catch (Exception e) {
                ArsAffinity.LOGGER.error("Failed to deserialize affinity data on client: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static SpellSchool getSchoolFromId(String id) {
        return switch (id) {
            case "ars_nouveau:elemental_fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "ars_nouveau:elemental_water" -> SpellSchools.ELEMENTAL_WATER;
            case "ars_nouveau:elemental_earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "ars_nouveau:elemental_air" -> SpellSchools.ELEMENTAL_AIR;
            case "ars_nouveau:abjuration" -> SpellSchools.ABJURATION;
            case "ars_nouveau:necromancy" -> SpellSchools.NECROMANCY;
            case "ars_nouveau:conjuration" -> SpellSchools.CONJURATION;
            case "ars_nouveau:manipulation" -> SpellSchools.MANIPULATION;
            default -> null;
        };
    }
}

