/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability.field;

import com.github.ars_affinity.common.ability.field.AbstractFieldAbility;
import com.github.ars_affinity.common.ability.field.ActiveFieldRegistry;
import com.github.ars_affinity.common.network.LoopingSoundPacket;
import com.github.ars_affinity.common.network.Networking;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.registry.ModPotions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SanctuaryHelper
extends AbstractFieldAbility {
    public static final int DEFAULT_HALF_EXTENT_X = 1;
    public static final int DEFAULT_HALF_EXTENT_Y = 1;
    public static final int DEFAULT_HALF_EXTENT_Z = 1;
    public static final double DEFAULT_MANA_COST_PER_TICK = 1.0;
    public static final int DEFAULT_COOLDOWN_TICKS = 100;

    public SanctuaryHelper(ServerPlayer player) {
        super(player, 1, 1, 1, 1.0, 100);
    }

    public SanctuaryHelper(ServerPlayer player, double manaCostPerTick, int cooldownTicks) {
        super(player, 1, 1, 1, manaCostPerTick, cooldownTicks);
    }

    public static void toggleOrStart(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        if (player.hasEffect(ModPotions.SANCTUARY_COOLDOWN_EFFECT)) {
            return;
        }
        boolean wasStarted = ActiveFieldRegistry.toggleOrStart(player, () -> new SanctuaryHelper(player, perk.manaCost, perk.cooldown));
        if (wasStarted) {
            Networking.sendToPlayerClient((CustomPacketPayload)new LoopingSoundPacket(player.getId(), "sanctuary", true), player);
        }
    }

    @Override
    public void onTick() {
        for (LivingEntity e : this.getLivingEntitiesInField()) {
            e.addEffect(new MobEffectInstance(ModPotions.SANCTUARY_EFFECT, 10, 0, false, true, true));
        }
    }

    @Override
    public void onRelease() {
        this.player.addEffect(new MobEffectInstance(ModPotions.SANCTUARY_COOLDOWN_EFFECT, this.cooldownTicks, 0, false, true, true));
        Networking.sendToPlayerClient((CustomPacketPayload)new LoopingSoundPacket(this.player.getId(), "sanctuary", false), this.player);
    }

    @Override
    protected void renderParticles() {
        Level level = this.player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        AABB box = this.getFieldAABB();
        for (int i = 0; i < 12; ++i) {
            double x = box.minX + this.player.getRandom().nextDouble() * (box.maxX - box.minX);
            double y = box.minY + this.player.getRandom().nextDouble() * (box.maxY - box.minY);
            double z = box.minZ + this.player.getRandom().nextDouble() * (box.maxZ - box.minZ);
            sl.sendParticles((ParticleOptions)ParticleTypes.GLOW, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            sl.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

