/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability.field;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.common.ability.field.AbstractFieldAbility;
import com.github.ars_affinity.common.ability.field.ActiveFieldRegistry;
import com.github.ars_affinity.common.network.LoopingSoundPacket;
import com.github.ars_affinity.common.network.Networking;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.registry.ModPotions;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CurseFieldHelper
extends AbstractFieldAbility {
    public static final int DEFAULT_HALF_EXTENT_X = 3;
    public static final int DEFAULT_HALF_EXTENT_Y = 1;
    public static final int DEFAULT_HALF_EXTENT_Z = 3;
    public static final double DEFAULT_MANA_COST_PER_TICK = 1.0;
    public static final int DEFAULT_COOLDOWN_TICKS = 100;

    public CurseFieldHelper(ServerPlayer player) {
        super(player, 3, 1, 3, 1.0, 100);
    }

    public CurseFieldHelper(ServerPlayer player, double manaCostPerTick, int cooldownTicks) {
        super(player, 3, 1, 3, manaCostPerTick, cooldownTicks);
    }

    public static void toggleOrStart(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        if (player.hasEffect(ModPotions.CURSE_FIELD_COOLDOWN_EFFECT)) {
            return;
        }
        ArsAffinity.LOGGER.info("CURSE FIELD start: manaCostPerTick={} cooldownTicks={}", (Object)Float.valueOf(perk.manaCost), (Object)perk.cooldown);
        boolean wasStarted = ActiveFieldRegistry.toggleOrStart(player, () -> new CurseFieldHelper(player, perk.manaCost, perk.cooldown));
        if (wasStarted) {
            Networking.sendToPlayerClient((CustomPacketPayload)new LoopingSoundPacket(player.getId(), "curse_field", true), player);
        }
    }

    @Override
    public void onTick() {
        for (LivingEntity e : this.getLivingEntitiesInField()) {
            if (e == this.player || e.getType().is(EntityTypeTags.UNDEAD)) continue;
            e.addEffect(new MobEffectInstance(ModPotions.SILENCED_EFFECT, 20, 0, false, true, true));
            e.hurt(this.player.damageSources().magic(), 1.0f);
            this.player.heal(0.5f);
            ManaCap manaCap = CapabilityRegistry.getMana((LivingEntity)this.player);
            if (manaCap == null) continue;
            manaCap.addMana(1.0);
        }
    }

    @Override
    public void onRelease() {
        this.player.addEffect(new MobEffectInstance(ModPotions.CURSE_FIELD_COOLDOWN_EFFECT, this.cooldownTicks, 0, false, true, true));
        Networking.sendToPlayerClient((CustomPacketPayload)new LoopingSoundPacket(this.player.getId(), "curse_field", false), this.player);
    }

    @Override
    protected void renderParticles() {
        Level level = this.player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        AABB box = this.getFieldAABB();
        for (int i = 0; i < 10; ++i) {
            double x = box.minX + this.player.getRandom().nextDouble() * (box.maxX - box.minX);
            double y = box.minY + this.player.getRandom().nextDouble() * (box.maxY - box.minY);
            double z = box.minZ + this.player.getRandom().nextDouble() * (box.maxZ - box.minZ);
            sl.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            sl.sendParticles((ParticleOptions)ParticleTypes.SOUL, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

