/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability.field;

import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractFieldAbility {
    protected final ServerPlayer player;
    protected final int halfExtentX;
    protected final int halfExtentY;
    protected final int halfExtentZ;
    protected final double manaCostPerTick;
    protected final int cooldownTicks;

    protected AbstractFieldAbility(ServerPlayer player, int halfExtentX, int halfExtentY, int halfExtentZ, double manaCostPerTick, int cooldownTicks) {
        this.player = player;
        this.halfExtentX = halfExtentX;
        this.halfExtentY = halfExtentY;
        this.halfExtentZ = halfExtentZ;
        this.manaCostPerTick = manaCostPerTick;
        this.cooldownTicks = cooldownTicks;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public AABB getFieldAABB() {
        Vec3 p = this.player.position();
        return new AABB(p.x - (double)this.halfExtentX, p.y - (double)this.halfExtentY, p.z - (double)this.halfExtentZ, p.x + (double)this.halfExtentX, p.y + (double)this.halfExtentY, p.z + (double)this.halfExtentZ);
    }

    public boolean isEntityInsideField(LivingEntity entity) {
        return this.getFieldAABB().intersects(entity.getBoundingBox());
    }

    protected boolean tryConsumeManaTick() {
        ManaCap manaCap = CapabilityRegistry.getMana((LivingEntity)this.player);
        if (manaCap == null) {
            return false;
        }
        double cost = Math.max(1.0, Math.floor(this.manaCostPerTick));
        if (manaCap.getCurrentMana() < cost) {
            return false;
        }
        manaCap.removeMana((double)((int)cost));
        return true;
    }

    public final boolean tick() {
        if (!(this.player.level() instanceof ServerLevel)) {
            return true;
        }
        if (!this.tryConsumeManaTick()) {
            return false;
        }
        this.onTick();
        this.renderParticles();
        return true;
    }

    public abstract void onTick();

    public abstract void onRelease();

    protected abstract void renderParticles();

    protected List<LivingEntity> getLivingEntitiesInField() {
        AABB box = this.getFieldAABB();
        return this.player.level().getEntitiesOfClass(LivingEntity.class, box, e -> e.isAlive());
    }
}

