/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.me.strategy;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import es.degrassi.appexp.me.key.ExperienceKey;
import es.degrassi.appexp.me.key.ExperienceKeyType;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperienceStackImportStrategy
implements StackImportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperienceStackImportStrategy.class);
    private final BlockCapabilityCache<IExperienceHandler, Direction> cache;

    public ExperienceStackImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create((BlockCapability)ExperienceLibCapabilities.EXPERIENCE.block(), (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    public boolean transfer(StackTransferContext context) {
        long inserted;
        if (!context.isKeyTypeEnabled(ExperienceKeyType.TYPE)) {
            return false;
        }
        IExperienceHandler handler = (IExperienceHandler)this.cache.getCapability();
        if (handler == null) {
            return false;
        }
        long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)ExperienceKeyType.TYPE.getAmountPerOperation();
        long rawAmount = Math.min(remainingTransferAmount, handler.getExperience());
        MEStorage inv = context.getInternalStorage().getInventory();
        long amount = inv.insert((AEKey)ExperienceKey.KEY, rawAmount, Actionable.SIMULATE, context.getActionSource());
        long extractable = 0L;
        if (amount > 0L) {
            long extract;
            for (int i = 0; i < handler.getTanks() && amount > 0L; amount -= extract, ++i) {
                extract = handler.extractExperience(i, amount, true);
                extractable += extract;
            }
        }
        if ((inserted = StorageHelper.poweredInsert((IEnergySource)context.getEnergySource(), (MEStorage)inv, (AEKey)ExperienceKey.KEY, (long)extractable, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE)) > 0L) {
            for (int i = 0; i < handler.getTanks() && inserted > 0L; inserted -= handler.extractExperience(i, inserted, false), ++i) {
            }
        }
        long opsUsed = Math.max(1L, extractable / (long)ExperienceKeyType.TYPE.getAmountPerOperation());
        context.reduceOperationsRemaining(opsUsed);
        return amount > 0L;
    }
}

