/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.item;

import es.degrassi.appexp.block.ExperienceConverterBlock;
import es.degrassi.appexp.definition.AExpComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;

public class ExperienceConverterItem
extends BlockItem {
    public ExperienceConverterItem(ExperienceConverterBlock block, Item.Properties properties) {
        super((Block)block, properties.component(AExpComponents.EXPERIENCE_AMOUNT, (Object)0L).component(AExpComponents.IN_INV, (Object)ItemContainerContents.fromItems(List.of(ItemStack.EMPTY))).component(AExpComponents.OUT_INV, (Object)ItemContainerContents.fromItems(List.of(ItemStack.EMPTY))));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        long amount = Optional.ofNullable((Long)stack.get(AExpComponents.EXPERIENCE_AMOUNT)).orElse(0L);
        ItemContainerContents inContents = Optional.ofNullable((ItemContainerContents)stack.get(AExpComponents.IN_INV)).orElse(ItemContainerContents.fromItems(List.of(ItemStack.EMPTY)));
        ItemContainerContents outContents = Optional.ofNullable((ItemContainerContents)stack.get(AExpComponents.OUT_INV)).orElse(ItemContainerContents.fromItems(List.of(ItemStack.EMPTY)));
        tooltipComponents.add((Component)Component.translatable((String)"appex.item.converter.tooltip", (Object[])new Object[]{amount}));
        ItemStack s = ItemStack.EMPTY;
        if (inContents.getSlots() > 0) {
            s = inContents.getStackInSlot(0);
        }
        tooltipComponents.add((Component)Component.translatable((String)"appex.item.converter.inv.in", (Object[])new Object[]{inContents.getSlots() > 0 ? s.getCount() + "x " + s.getHoverName().getString() : "Empty"}));
        if (outContents.getSlots() > 0) {
            s = outContents.getStackInSlot(0);
        }
        tooltipComponents.add((Component)Component.translatable((String)"appex.item.converter.inv.out", (Object[])new Object[]{outContents.getSlots() > 0 ? s.getCount() + "x " + s.getHoverName().getString() : "Empty"}));
    }
}

