/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.undergarden;

import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import quek.undergarden.registry.UGArmorMaterials;
import quek.undergarden.registry.UGItemTiers;

public class UndergardenAffixLootProvider
extends AffixLootEntryProvider {
    String mod = "undergarden";
    private static ResourceKey<Level> UNDERGARDEN = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"undergarden:undergarden"));
    public Map<Holder<ArmorMaterial>, TieredWeights> armorWeights = new HashMap<Holder<ArmorMaterial>, TieredWeights>();
    public Map<Tier, TieredWeights> toolWeights = new HashMap<Tier, TieredWeights>();
    public Map<Item, TieredWeights> itemWeights = new HashMap<Item, TieredWeights>();
    protected static final TieredWeights CLOGGRUM = TieredWeights.builder().with(WorldTier.FRONTIER, 15, 0.0f).with(WorldTier.ASCENT, 25, 0.0f).build();
    protected static final TieredWeights ANCIENT = TieredWeights.builder().with(WorldTier.FRONTIER, 15, 0.0f).with(WorldTier.ASCENT, 25, 0.0f).build();
    protected static final TieredWeights FROSTSTEEL = TieredWeights.builder().with(WorldTier.ASCENT, 15, 0.0f).with(WorldTier.SUMMIT, 25, 0.0f).build();
    protected static final TieredWeights UTHERIUM = TieredWeights.builder().with(WorldTier.SUMMIT, 15, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();
    protected static final TieredWeights FORGOTTEN = TieredWeights.builder().with(WorldTier.SUMMIT, 15, 0.0f).with(WorldTier.PINNACLE, 25, 0.0f).build();

    public UndergardenAffixLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void generate() {
        this.armorWeights.put((Holder<ArmorMaterial>)UGArmorMaterials.CLOGGRUM, CLOGGRUM);
        this.armorWeights.put((Holder<ArmorMaterial>)UGArmorMaterials.ANCIENT, ANCIENT);
        this.armorWeights.put((Holder<ArmorMaterial>)UGArmorMaterials.FROSTSTEEL, FROSTSTEEL);
        this.armorWeights.put((Holder<ArmorMaterial>)UGArmorMaterials.UTHERIUM, UTHERIUM);
        this.toolWeights.put((Tier)UGItemTiers.CLOGGRUM, CLOGGRUM);
        this.toolWeights.put((Tier)UGItemTiers.FROSTSTEEL, FROSTSTEEL);
        this.toolWeights.put((Tier)UGItemTiers.UTHERIUM, UTHERIUM);
        this.toolWeights.put((Tier)UGItemTiers.FORGOTTEN, FORGOTTEN);
        for (Item i : BuiltInRegistries.ITEM) {
            ArmorItem a;
            TieredWeights weights;
            LootCategory cat;
            if (!this.mod.equals(BuiltInRegistries.ITEM.getKey((Object)i).getNamespace()) || (cat = LootCategory.forItem((ItemStack)i.getDefaultInstance())).isNone()) continue;
            if (i instanceof TieredItem) {
                TieredItem t = (TieredItem)i;
                weights = this.toolWeights.get(t.getTier());
                if (weights == null) continue;
                this.addEntry(weights, new ItemStack((ItemLike)i));
                continue;
            }
            if (!(i instanceof ArmorItem) || (a = (ArmorItem)i).getType() == ArmorItem.Type.BODY || (weights = this.armorWeights.get(a.getMaterial())) == null) continue;
            this.addEntry(weights, new ItemStack((ItemLike)i));
        }
    }

    public String getName() {
        return "Undergarden Affix Loot Entries";
    }

    protected void addEntry(TieredWeights weights, ItemStack stack) {
        ResourceLocation key = ApothicCompats.loc(this.mod + "/" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath());
        this.addConditionally(key, (CodecProvider)new AffixLootEntry(weights, Constraints.forDimension(UNDERGARDEN), stack, Set.of()), new ICondition[]{new ModLoadedCondition(this.mod)});
    }
}

