/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.malum;

import com.sammy.malum.registry.common.MalumAttributes;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.affix.AttributeAffix;
import dev.shadowsoffire.apotheosis.affix.effect.DamageReductionAffix;
import dev.shadowsoffire.apotheosis.affix.effect.EnchantmentAffix;
import dev.shadowsoffire.apotheosis.affix.effect.MobEffectAffix;
import dev.shadowsoffire.apotheosis.data.AffixProvider;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import ianm1647.ancientreforging.AncientReforging;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.spongepowered.include.com.google.common.base.Preconditions;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;

public class MalumAffixProvider
extends AffixProvider {
    String mod = "malum";

    public MalumAffixProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "Malum Affixes";
    }

    public void generate() {
        LootRarity common = MalumAffixProvider.rarity("common");
        LootRarity uncommon = MalumAffixProvider.rarity("uncommon");
        LootRarity rare = MalumAffixProvider.rarity("rare");
        LootRarity epic = MalumAffixProvider.rarity("epic");
        LootRarity mythic = MalumAffixProvider.rarity("mythic");
        LootRarity ancient = MalumAffixProvider.ancientRarity("ancient");
        this.addAttribute("armor", "ward_capacity", (Holder<Attribute>)MalumAttributes.SOUL_WARD_CAPACITY, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(uncommon, 3.0f)).value(rare, 6.0f)).value(epic, 9.0f)).value(mythic, 12.0f));
        this.addAncientAttribute("armor", "ward_capacity", (Holder<Attribute>)MalumAttributes.SOUL_WARD_CAPACITY, AttributeModifier.Operation.ADD_VALUE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(ancient, 15.0f));
        this.addAttribute("armor", "ward_integrity", (Holder<Attribute>)MalumAttributes.SOUL_WARD_INTEGRITY, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(uncommon, 0.1f, 0.2f)).value(rare, 0.2f, 0.3f)).value(epic, 0.3f, 0.4f)).value(mythic, 0.4f, 0.5f));
        this.addAncientAttribute("armor", "ward_integrity", (Holder<Attribute>)MalumAttributes.SOUL_WARD_INTEGRITY, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(ancient, 0.5f, 0.6f));
        this.addAttribute("armor", "abjured", (Holder<Attribute>)LodestoneAttributes.MAGIC_RESISTANCE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(uncommon, 0.05f, 0.15f)).value(rare, 0.15f, 0.25f)).value(epic, 0.25f, 0.35f)).value(mythic, 0.35f, 0.45f));
        this.addAncientAttribute("armor", "abjured", (Holder<Attribute>)LodestoneAttributes.MAGIC_RESISTANCE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(ancient, 0.45f, 0.55f));
        this.addAttribute("armor", "adept", (Holder<Attribute>)LodestoneAttributes.MAGIC_PROFICIENCY, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(rare, 0.3f, 0.4f)).value(epic, 0.4f, 0.5f)).value(mythic, 0.5f, 0.6f));
        this.addAncientAttribute("armor", "adept", (Holder<Attribute>)LodestoneAttributes.MAGIC_PROFICIENCY, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(ancient, 0.6f, 0.7f));
        this.addAttribute("armor", "scythe_proficiency", (Holder<Attribute>)MalumAttributes.SCYTHE_PROFICIENCY, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(uncommon, 0.1f, 0.2f)).value(rare, 0.2f, 0.3f)).value(epic, 0.3f, 0.4f)).value(mythic, 0.4f, 0.5f));
        this.addAncientAttribute("armor", "scythe_proficiency", (Holder<Attribute>)MalumAttributes.SCYTHE_PROFICIENCY, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(ancient, 0.5f, 0.6f));
        this.addAttribute("armor", "malevolent", (Holder<Attribute>)MalumAttributes.MALIGNANT_CONVERSION, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(uncommon, 0.05f, 0.15f)).value(rare, 0.15f, 0.25f)).value(epic, 0.25f, 0.35f)).value(mythic, 0.35f, 0.45f));
        this.addAncientAttribute("armor", "malevolent", (Holder<Attribute>)MalumAttributes.MALIGNANT_CONVERSION, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, b -> (AttributeAffix.Builder)((AttributeAffix.Builder)b.definition(AffixType.STAT, 25, 0.1f)).categories(ARMOR).value(ancient, 0.45f, 0.55f));
    }

    private void addEnchantment(String type, String name, Holder<Enchantment> enchantment, EnchantmentAffix.Mode mode, UnaryOperator<EnchantmentAffix.Builder> config) {
        EnchantmentAffix.Builder builder = new EnchantmentAffix.Builder(enchantment, mode);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/enchantment/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    private void addMobEffect(String type, String name, Holder<MobEffect> effect, MobEffectAffix.Target target, UnaryOperator<MobEffectAffix.Builder> config) {
        MobEffectAffix.Builder builder = new MobEffectAffix.Builder(effect, target);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/mob_effect/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    private void addDamageReduction(String type, String name, DamageReductionAffix.DamageType dType, UnaryOperator<DamageReductionAffix.Builder> config) {
        DamageReductionAffix.Builder builder = new DamageReductionAffix.Builder(dType);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/dmg_reduction/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    private void addAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    private void addAncientEnchantment(String type, String name, Holder<Enchantment> enchantment, EnchantmentAffix.Mode mode, UnaryOperator<EnchantmentAffix.Builder> config) {
        EnchantmentAffix.Builder builder = new EnchantmentAffix.Builder(enchantment, mode);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/enchantment/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private void addAncientMobEffect(String type, String name, Holder<MobEffect> effect, MobEffectAffix.Target target, UnaryOperator<MobEffectAffix.Builder> config) {
        MobEffectAffix.Builder builder = new MobEffectAffix.Builder(effect, target);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/mob_effect/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private void addAncientDamageReduction(String type, String name, DamageReductionAffix.DamageType dType, UnaryOperator<DamageReductionAffix.Builder> config) {
        DamageReductionAffix.Builder builder = new DamageReductionAffix.Builder(dType);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/dmg_reduction/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private void addAncientAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private static DynamicHolder<Affix> afx(String path) {
        return AffixRegistry.INSTANCE.holder(Apotheosis.loc((String)path));
    }

    private static LootRarity rarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(Apotheosis.loc((String)path))));
    }

    private static LootRarity ancientRarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(AncientReforging.loc((String)path))));
    }
}

