/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.commands;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.config.ATLProperties;
import dev.uncandango.alltheleaks.diag.common.mods.minecraft.DebugChunkLoading;
import dev.uncandango.alltheleaks.diag.common.mods.minecraft.DebugNativeImage;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.MemoryMonitor;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.SaveWithLoadedChunks;
import dev.uncandango.alltheleaks.mixin.Trackable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableObject;
import org.embeddedt.modernfix.world.ThreadDumper;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public final class ATLCommands {
    public static void registerClientCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"atl").then(Commands.literal((String)"run_explicit_gc").executes(cmd -> ATLCommands.runGc((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"clear_native_images").executes(cmd -> ATLCommands.clearNativeImages((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"force_refresh").executes(cmd -> ATLCommands.checkLeaking((CommandSourceStack)cmd.getSource(), true)))).then(Commands.literal((String)"reset_statistics").executes(cmd -> ATLCommands.resetStatistics((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"thread_dump").requires(source -> ModList.get().isLoaded("modernfix"))).executes(cmd -> ATLCommands.doModernFixThreadDump((CommandSourceStack)cmd.getSource()))));
    }

    private static int doModernFixThreadDump(CommandSourceStack source) {
        AllTheLeaks.LOGGER.error(ThreadDumper.obtainThreadDump());
        source.sendSystemMessage((Component)Component.literal((String)"Thread dump done, check latest.log"));
        return 1;
    }

    private static int resetStatistics(CommandSourceStack source) {
        ATLCommands.runGc(source);
        MemoryMonitor.Statistics.reset();
        return 1;
    }

    public static void registerCommonCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"atl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"track_chunk").requires(source -> ATLProperties.get().debugChunkLoading)).executes(cmd -> ATLCommands.clearTrackingChunks((CommandSourceStack)cmd.getSource()))).then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(cmd -> ATLCommands.startTrackingChunks((CommandSourceStack)cmd.getSource(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"x"), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"z"), null))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(cmd -> ATLCommands.startTrackingChunks((CommandSourceStack)cmd.getSource(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"x"), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"z"), DimensionArgument.getDimension((CommandContext)cmd, (String)"dimension")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"place_all_block_entities").requires(source -> AllTheLeaks.INDEV && source.getServer().isSingleplayer())).executes(cmd -> ATLCommands.placeAllBes((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"backup_with_loaded_chunks").requires(source -> source.getServer().isSingleplayer() || source.hasPermission(2))).executes(cmd -> SaveWithLoadedChunks.saveWorld((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"load_chunks_from_backup").requires(source -> source.getServer().isSingleplayer() || source.hasPermission(2))).executes(cmd -> SaveWithLoadedChunks.loadChunksFromSaveFile((CommandSourceStack)cmd.getSource()))));
    }

    public static void registerServerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"atl").then(Commands.literal((String)"run_explicit_gc").executes(cmd -> ATLCommands.runGc((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"force_refresh").executes(cmd -> ATLCommands.checkLeaking((CommandSourceStack)cmd.getSource(), true)))).then(Commands.literal((String)"reset_statistics").executes(cmd -> ATLCommands.resetStatistics((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"thread_dump").requires(source -> ModList.get().isLoaded("modernfix"))).executes(cmd -> ATLCommands.doModernFixThreadDump((CommandSourceStack)cmd.getSource()))));
    }

    private static int placeAllBes(CommandSourceStack source) {
        HashSet ignoredBes = new HashSet();
        HashSet<String> ignoredMods = new HashSet<String>();
        Path ignoredFile = AllTheLeaks.getLocal().resolve("ignored_block_entities.txt");
        Path ignoredModsFile = AllTheLeaks.getLocal().resolve("ignored_mods.txt");
        if (Files.exists(ignoredFile, new LinkOption[0])) {
            try {
                Files.readAllLines(ignoredFile).stream().map(ResourceLocation::tryParse).filter(Objects::nonNull).forEach(ignoredBes::add);
            }
            catch (IOException e) {
                AllTheLeaks.LOGGER.error("Error while trying to read file", (Throwable)e);
            }
        }
        if (Files.exists(ignoredModsFile, new LinkOption[0])) {
            try {
                ignoredMods.addAll(Files.readAllLines(ignoredModsFile));
            }
            catch (IOException e) {
                AllTheLeaks.LOGGER.error("Error while trying to read file", (Throwable)e);
            }
        }
        List<ResourceLocation> validBes = source.registryAccess().lookupOrThrow(Registries.BLOCK_ENTITY_TYPE).listElements().map(Holder.Reference::value).flatMap(bet -> bet.getValidBlocks().stream()).map(Block::builtInRegistryHolder).map(Holder.Reference::getKey).filter(Objects::nonNull).map(ResourceKey::location).filter(rl -> !ignoredBes.contains(rl) && !ignoredMods.contains(rl.getNamespace())).toList();
        final ServerPlayer player = Objects.requireNonNull(source.getPlayer());
        final ResourceLocation dimension = player.level().dimension().location();
        final MinecraftServer server = source.getServer();
        int beIndex = 0;
        int spiralRadius = (int)Math.ceil((Math.sqrt(validBes.size()) - 1.0) / 2.0);
        final ConcurrentLinkedQueue<Pair> setBlocksQueue = new ConcurrentLinkedQueue<Pair>();
        for (BlockPos.MutableBlockPos pos : BlockPos.spiralAround((BlockPos)player.blockPosition(), (int)spiralRadius, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            if (beIndex >= validBes.size()) break;
            String be = validBes.get(beIndex).toString();
            setBlocksQueue.add(Pair.of((Object)pos.immutable(), (Object)be));
            ++beIndex;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"Placing %s block entities...", (Object[])new Object[]{setBlocksQueue.size()}));
        final MutableObject eventListener = new MutableObject();
        eventListener.setValue(new Object(){
            final int initialValue;
            int threshold;
            {
                this.initialValue = setBlocksQueue.size();
                this.threshold = 1;
            }

            @SubscribeEvent
            public void onLevelTick(LevelTickEvent.Post event) {
                if (!event.getLevel().equals(player.level())) {
                    return;
                }
                while (event.hasTime() && !setBlocksQueue.isEmpty()) {
                    Pair job = (Pair)setBlocksQueue.poll();
                    BlockPos pos = (BlockPos)job.getFirst();
                    String be = (String)job.getSecond();
                    AllTheLeaks.LOGGER.info("Placing {} at {} {}", new Object[]{be, dimension, pos.toShortString()});
                    String commandString = "execute in " + String.valueOf(dimension) + " run setblock " + pos.getX() + " " + pos.getY() + " " + pos.getZ() + " " + be;
                    server.getCommands().performPrefixedCommand(player.createCommandSourceStack().withSuppressedOutput(), commandString);
                }
                if (setBlocksQueue.isEmpty()) {
                    player.sendSystemMessage((Component)Component.literal((String)"Placing blocks finished!"));
                    NeoForge.EVENT_BUS.unregister(eventListener.getValue());
                } else if ((double)setBlocksQueue.size() < (double)this.initialValue * (1.0 - (double)this.threshold / 10.0)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"%s blocks remaining...", (Object[])new Object[]{setBlocksQueue.size()}));
                    ++this.threshold;
                }
            }
        });
        NeoForge.EVENT_BUS.register(eventListener.getValue());
        return 0;
    }

    public static int startTrackingChunks(CommandSourceStack source, int x, int z, @Nullable ServerLevel level) {
        if (level == null) {
            level = source.getLevel();
        }
        ChunkPos chunkPos = new ChunkPos(x, z);
        ResourceKey dimension = level.dimension();
        DebugChunkLoading.addTrackingChunk((ResourceKey<Level>)dimension, chunkPos);
        source.sendSuccess(() -> Component.translatable((String)"Starting to track events for chunk %s from dimension %s", (Object[])new Object[]{Component.literal((String)chunkPos.toString()).withStyle(ChatFormatting.GREEN), Component.literal((String)dimension.location().toString()).withStyle(ChatFormatting.YELLOW)}), true);
        return 1;
    }

    public static int clearTrackingChunks(CommandSourceStack source) {
        DebugChunkLoading.clearTrackingChunks();
        source.sendSuccess(() -> Component.literal((String)"Cleared tracking chunks, now tracking everything."), true);
        return 1;
    }

    public static int checkLeaking(CommandSourceStack source, boolean shouldRunGc) {
        if (shouldRunGc && ATLCommands.runGc(source) == 0) {
            return 0;
        }
        Trackable.clearNullReferences();
        AllTheLeaks.LOGGER.info("Logging events from checking leak");
        MemoryMonitor.getEventsSummary().forEach(arg_0 -> ((Logger)AllTheLeaks.LOGGER).info(arg_0));
        ArrayList lines = new ArrayList();
        Trackable.getSummary().forEach((baseClazz, summaryMap) -> {
            if (summaryMap.isEmpty()) {
                return;
            }
            lines.add(Component.translatable((String)"%s:", (Object[])new Object[]{baseClazz.getSimpleName()}));
            summaryMap.forEach((innerClazz, count) -> {
                Module module = innerClazz.getModule();
                if (module != null) {
                    lines.add(Component.translatable((String)"- %s (%s): %s", (Object[])new Object[]{innerClazz.getSimpleName(), module.getName(), count}));
                } else {
                    lines.add(Component.translatable((String)"- %s: %s", (Object[])new Object[]{innerClazz.getSimpleName(), count}));
                }
            });
        });
        if (lines.isEmpty()) {
            source.sendSystemMessage((Component)Component.literal((String)"No leak was found so far...").withStyle(ChatFormatting.GREEN));
        } else {
            source.sendSystemMessage((Component)Component.literal((String)"Listing leaks...").withStyle(ChatFormatting.YELLOW));
            lines.forEach(arg_0 -> ((CommandSourceStack)source).sendSystemMessage(arg_0));
        }
        return 1;
    }

    private static int clearNativeImages(CommandSourceStack source) {
        if (!ATLProperties.get().debugNativeImage) {
            source.sendFailure((Component)Component.literal((String)"DebugNativeImage is disabled, activate it at config/alltheleaks.json"));
            return 0;
        }
        AtomicInteger counter = new AtomicInteger();
        DebugNativeImage.NATIVE_IMAGES_TRACKER.forEach((k, v) -> {
            Set setWithEmptyRef = Collections.synchronizedSet(new HashSet());
            v.forEach(wr -> {
                NativeImage ref = (NativeImage)wr.imageRef().get();
                if (ref == null) {
                    setWithEmptyRef.add(wr);
                }
            });
            if (!v.isEmpty() && setWithEmptyRef.size() == v.size()) {
                AllTheLeaks.LOGGER.info("Removed all NativeImages for key {}", k);
                if (k.useStbFree()) {
                    STBImage.nstbi_image_free((long)k.pixels());
                } else {
                    MemoryUtil.nmemFree((long)k.pixels());
                }
                setWithEmptyRef.forEach(wr -> {
                    counter.getAndIncrement();
                    AllTheLeaks.LOGGER.info("Printing stack trace for: {}", (Object)wr.description());
                    boolean reachedInit = false;
                    for (StackTraceElement trace : wr.stackTraceElements()) {
                        if (!reachedInit) {
                            reachedInit = trace.getMethodName().contains("init");
                        }
                        if (!reachedInit) continue;
                        System.out.println("\tat " + trace.getClassName() + "." + trace.getMethodName() + "(" + trace.getFileName() + ":" + trace.getLineNumber() + ")");
                    }
                });
                v.clear();
            }
        });
        source.sendSuccess(() -> Component.literal((String)("Cleared " + counter.get() + " NativeImages")), true);
        return 1;
    }

    public static int runGc(CommandSourceStack source) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.executeBlocking(() -> server.saveEverything(true, true, true));
        }
        if (!MemoryMonitor.runExplicitGc()) {
            source.sendFailure((Component)Component.literal((String)"Explicit GC is disabled, remove arguments -XX:+DisableExplicitGC"));
            return 0;
        }
        return 1;
    }
}

