/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditionsClient;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public final class WorldUtil {
    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract) {
        return WorldUtil.doItemInteraction(extractWrapper, insertWrapper, maxExtract, null);
    }

    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract, FilterSettings filter) {
        return WorldUtil.doItemInteraction(extractWrapper, insertWrapper, maxExtract, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, filter);
    }

    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract, int extractSlotStart, int extractSlotEnd, int insertSlotStart, int insertSlotEnd, FilterSettings filter) {
        ItemStack remaining;
        ItemStack theoreticalExtract = WorldUtil.extractItem(extractWrapper, maxExtract, true, extractSlotStart, extractSlotEnd, filter);
        if (!theoreticalExtract.isEmpty() && !ItemStack.matches((ItemStack)(remaining = StackUtil.insertItem(insertWrapper, theoreticalExtract, false, insertSlotStart, insertSlotEnd)), (ItemStack)theoreticalExtract)) {
            int toExtract = theoreticalExtract.getCount() - remaining.getCount();
            WorldUtil.extractItem(extractWrapper, toExtract, false, extractSlotStart, extractSlotEnd, filter);
            return true;
        }
        return false;
    }

    public static ItemStack extractItem(SlotlessableItemHandlerWrapper extractWrapper, int maxExtract, boolean simulate, int slotStart, int slotEnd, FilterSettings filter) {
        IItemHandler handler;
        ItemStack extracted = ItemStack.EMPTY;
        if (ActuallyAdditions.commonCapsLoaded) {
            // empty if block
        }
        if (extracted.isEmpty() && (handler = extractWrapper.getNormalHandler()) != null) {
            for (int i = Math.max(0, slotStart); i < Math.min(slotEnd, handler.getSlots()) && (filter != null && filter.needsCheck() && !filter.check(handler.getStackInSlot(i)) || (extracted = handler.extractItem(i, maxExtract, simulate)).isEmpty()); ++i) {
            }
        }
        return extracted;
    }

    public static void doEnergyInteraction(Level level, BlockPos posFrom, BlockPos posTo, Direction sideTo, int maxTransfer) {
        if (maxTransfer > 0) {
            int drain;
            Direction opp = sideTo == null ? null : sideTo.getOpposite();
            IEnergyStorage handlerFrom = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, posFrom, (Object)sideTo);
            IEnergyStorage handlerTo = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, posTo, (Object)opp);
            if (handlerFrom != null && handlerTo != null && (drain = handlerFrom.extractEnergy(maxTransfer, true)) > 0) {
                int filled = handlerTo.receiveEnergy(drain, false);
                handlerFrom.extractEnergy(filled, false);
            }
        }
    }

    public static void doFluidInteraction(Level level, BlockPos posFrom, BlockPos posTo, Direction sideTo, int maxTransfer) {
        if (maxTransfer > 0) {
            FluidStack drain;
            IFluidHandler handlerFrom = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, posFrom, (Object)sideTo);
            IFluidHandler handlerTo = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, posTo, (Object)sideTo.getOpposite());
            if (handlerFrom != null && handlerTo != null && !(drain = handlerFrom.drain(maxTransfer, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
                int filled = handlerTo.fill(drain.copy(), IFluidHandler.FluidAction.EXECUTE);
                handlerFrom.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public static boolean hasBlocksInPlacesGiven(BlockPos[] positions, Block block, Level level) {
        for (BlockPos pos : positions) {
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() == block) continue;
            return false;
        }
        return true;
    }

    public static ItemStack useItemAtSide(Direction side, Level level, BlockPos pos, @Nonnull ItemStack stack) {
        if (level instanceof ServerLevel && !stack.isEmpty() && pos != null) {
            BlockPos offsetPos = pos.relative(side);
            BlockState state = level.getBlockState(offsetPos);
            boolean replaceable = state.canBeReplaced(new BlockPlaceContext(level, null, InteractionHand.MAIN_HAND, stack, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), side, pos, false)));
            if (replaceable && stack.getItem() == Items.REDSTONE) {
                level.setBlock(offsetPos, Blocks.REDSTONE_WIRE.defaultBlockState(), 2);
                return StackUtil.shrink(stack, 1);
            }
            try {
                FakePlayer fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
                WorldUtil.setHandItemWithoutAnnoyingSound((Player)fake, InteractionHand.MAIN_HAND, stack.copy());
                BlockHitResult ray = new BlockHitResult(new Vec3(0.5, 0.5, 0.5), side.getOpposite(), offsetPos, true);
                fake.gameMode.useItemOn((ServerPlayer)fake, level, fake.getMainHandItem(), InteractionHand.MAIN_HAND, ray);
                ItemStack result = fake.getItemInHand(InteractionHand.MAIN_HAND);
                return result;
            }
            catch (Exception e) {
                ActuallyAdditions.LOGGER.error("Something that places Blocks at {}, {}, {} in World {} threw an Exception! Don't let that happen again!", new Object[]{offsetPos.getX(), offsetPos.getY(), offsetPos.getZ(), level.dimension(), e});
            }
        }
        return stack;
    }

    public static boolean dropItemAtSide(Direction side, Level level, BlockPos pos, ItemStack stack) {
        BlockPos coords = pos.relative(side);
        if (level.hasChunkAt(coords)) {
            ItemEntity item = new ItemEntity(level, (double)coords.getX() + 0.5, (double)coords.getY() + 0.5, (double)coords.getZ() + 0.5, stack);
            item.setDeltaMovement(0.0, 0.0, 0.0);
            return level.addFreshEntity((Entity)item);
        }
        return false;
    }

    public static Direction getDirectionBySidesInOrder(int side) {
        switch (side) {
            case 0: {
                return Direction.UP;
            }
            case 1: {
                return Direction.DOWN;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.EAST;
            }
            case 4: {
                return Direction.SOUTH;
            }
        }
        return Direction.WEST;
    }

    public static Direction getDirectionByPistonRotation(BlockState state) {
        return (Direction)state.getValue((Property)BlockStateProperties.FACING);
    }

    public static ArrayList<BlockState> getStatesAround(Level level, BlockPos pos) {
        ArrayList<BlockState> blocks = new ArrayList<BlockState>();
        blocks.add(level.getBlockState(pos.relative(Direction.NORTH)));
        blocks.add(level.getBlockState(pos.relative(Direction.EAST)));
        blocks.add(level.getBlockState(pos.relative(Direction.SOUTH)));
        blocks.add(level.getBlockState(pos.relative(Direction.WEST)));
        return blocks;
    }

    public static void setHandItemWithoutAnnoyingSound(Player player, InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            player.getInventory().items.set(player.getInventory().selected, (Object)stack);
        } else if (hand == InteractionHand.OFF_HAND) {
            player.getInventory().offhand.set(0, (Object)stack);
        }
    }

    public static float fireFakeHarvestEventsForDropChance(BlockEntity caller, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            FakePlayer fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
            ItemStack fakeTool = new ItemStack((ItemLike)ActuallyItems.NETHERITE_AIOT.get());
            fake.getInventory().items.set(fake.getInventory().selected, (Object)fakeTool);
            BlockPos tePos = caller.getBlockPos();
            fake.setPos((double)tePos.getX() + 0.5, (double)tePos.getY() + 0.5, (double)tePos.getZ() + 0.5);
            BlockState state = level.getBlockState(pos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (Player)fake);
            NeoForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                return EventHooks.doPlayerHarvestCheck((Player)fake, (BlockState)state, (BlockGetter)level, (BlockPos)pos) ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    public static boolean breakExtraBlock(ItemStack stack, Level level, Player player, BlockPos pos) {
        if (player.isCreative()) {
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (block.onDestroyedByPlayer(state, level, pos, player, false, state.getFluidState())) {
                block.destroy((LevelAccessor)level, pos, state);
            }
            if (!level.isClientSide) {
                // empty if block
            }
            return true;
        }
        BlockState tempstate = level.getBlockState(pos);
        BlockState state = tempstate.getBlock().playerWillDestroy(level, pos, tempstate, player);
        Block block = state.getBlock();
        if (state.isAir()) {
            return false;
        }
        stack.mineBlock(level, state, pos, player);
        if (!level.isClientSide) {
            BlockEvent.BreakEvent event = CommonHooks.fireBlockBreak((Level)level, (GameType)((ServerPlayer)player).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos, (BlockState)state);
            if (event.isCanceled()) {
                return false;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (block.onDestroyedByPlayer(state, level, pos, player, true, state.getFluidState())) {
                block.destroy((LevelAccessor)level, pos, state);
                block.playerDestroy(level, player, pos, state, blockEntity, stack);
            }
            return true;
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)state));
        if (block.onDestroyedByPlayer(state, level, pos, player, true, state.getFluidState())) {
            block.destroy((LevelAccessor)level, pos, state);
        }
        ActuallyAdditionsClient.sendBreakPacket(pos);
        return true;
    }
}

