/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.VoxelShapes;
import de.ellpeck.actuallyadditions.mod.blocks.base.FullyDirectionalBlock;
import de.ellpeck.actuallyadditions.mod.blocks.blockhuds.IBlockHud;
import de.ellpeck.actuallyadditions.mod.blocks.blockhuds.LaserRelayHud;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ItemLaserRelayUpgrade;
import de.ellpeck.actuallyadditions.mod.items.ItemLaserWrench;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyAdvanced;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyExtreme;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayFluids;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItemAdvanced;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockLaserRelay
extends FullyDirectionalBlock.Container
implements IHudDisplay {
    private static final IBlockHud HUD = new LaserRelayHud();
    private final Type type;

    public BlockLaserRelay(Type type) {
        super(ActuallyBlocks.defaultPickProps());
        this.type = type;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        ItemStack stack = player.getItemInHand(hand);
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileEntityLaserRelay) {
            ItemStack inRelay;
            TileEntityLaserRelay relay = (TileEntityLaserRelay)tile;
            if (!stack.isEmpty()) {
                if (stack.getItem() instanceof ItemLaserWrench) {
                    return ItemInteractionResult.FAIL;
                }
                if (stack.getItem() == CommonConfig.Other.relayConfigureItem) {
                    if (!world.isClientSide) {
                        relay.onCompassAction(player);
                        Network network = relay.getNetwork();
                        if (network != null) {
                            ++network.changeAmount;
                        }
                        relay.setChanged();
                        relay.sendUpdate();
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                if (stack.getItem() instanceof ItemLaserRelayUpgrade && (inRelay = relay.inv.getStackInSlot(0)).isEmpty()) {
                    if (!world.isClientSide) {
                        if (!player.isCreative()) {
                            player.setItemInHand(hand, StackUtil.shrink(stack, 1));
                        }
                        ItemStack set = stack.copy();
                        set.setCount(1);
                        relay.inv.setStackInSlot(0, set);
                    }
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
            }
            if (player.isShiftKeyDown() && !(inRelay = relay.inv.getStackInSlot(0).copy()).isEmpty()) {
                if (!world.isClientSide) {
                    relay.inv.setStackInSlot(0, ItemStack.EMPTY);
                    if (!player.getInventory().add(inRelay)) {
                        player.spawnAtLocation(inRelay, 0.0f);
                    }
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (relay instanceof TileEntityLaserRelayItemAdvanced) {
                return this.openGui2(world, player, pos, TileEntityLaserRelayItemAdvanced.class);
            }
        }
        return ItemInteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        switch (this.type.ordinal()) {
            case 4: {
                return new TileEntityLaserRelayItem(pos, state);
            }
            case 5: {
                return new TileEntityLaserRelayItemAdvanced(pos, state);
            }
            case 1: {
                return new TileEntityLaserRelayEnergyAdvanced(pos, state);
            }
            case 2: {
                return new TileEntityLaserRelayEnergyExtreme(pos, state);
            }
            case 3: {
                return new TileEntityLaserRelayFluids(pos, state);
            }
        }
        return new TileEntityLaserRelayEnergy(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        switch (this.type.ordinal()) {
            case 4: {
                return level.isClientSide ? TileEntityLaserRelayItem::clientTick : TileEntityLaserRelayItem::serverTick;
            }
            case 5: {
                return level.isClientSide ? TileEntityLaserRelayItemAdvanced::clientTick : TileEntityLaserRelayItemAdvanced::serverTick;
            }
            case 1: {
                return level.isClientSide ? TileEntityLaserRelayEnergyAdvanced::clientTick : TileEntityLaserRelayEnergyAdvanced::serverTick;
            }
            case 2: {
                return level.isClientSide ? TileEntityLaserRelayEnergyExtreme::clientTick : TileEntityLaserRelayEnergyExtreme::serverTick;
            }
            case 3: {
                return level.isClientSide ? TileEntityLaserRelayFluids::clientTick : TileEntityLaserRelayFluids::serverTick;
            }
        }
        return level.isClientSide ? TileEntityLaserRelayEnergy::clientTick : TileEntityLaserRelayEnergy::serverTick;
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state != newState) {
            ConcurrentSet<IConnectionPair> connectionPairs = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(pos, world);
            ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(pos, world);
            ArrayList relayPositions = new ArrayList();
            connectionPairs.forEach(pair -> {
                for (BlockPos pairPos : pair.getPositions()) {
                    if (pos.equals((Object)pairPos)) continue;
                    relayPositions.add(pairPos);
                }
            });
            relayPositions.forEach(relayPos -> {
                BlockEntity tile = world.getBlockEntity(relayPos);
                if (tile instanceof TileEntityLaserRelay) {
                    TileEntityLaserRelay relay = (TileEntityLaserRelay)tile;
                    relay.sendUpdate();
                }
            });
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Override
    public IBlockHud getHud() {
        return HUD;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case UP: {
                return VoxelShapes.LaserRelayShapes.SHAPE_U;
            }
            case DOWN: {
                return VoxelShapes.LaserRelayShapes.SHAPE_D;
            }
            case EAST: {
                return VoxelShapes.LaserRelayShapes.SHAPE_E;
            }
            case SOUTH: {
                return VoxelShapes.LaserRelayShapes.SHAPE_S;
            }
            case WEST: {
                return VoxelShapes.LaserRelayShapes.SHAPE_W;
            }
        }
        return VoxelShapes.LaserRelayShapes.SHAPE_N;
    }

    public static enum Type {
        ENERGY_BASIC,
        ENERGY_ADVANCED,
        ENERGY_EXTREME,
        FLUIDS,
        ITEM,
        ITEM_WHITELIST;

    }
}

