/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.item;

import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.api.pattern.IMatterPatternHolder;
import com.buuz135.replication.api.pattern.IMatterPatternModifier;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.item.ReplicationItem;
import com.hrznstudio.titanium.item.BasicItem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MemoryChipItem
extends ReplicationItem
implements IMatterPatternHolder<ItemStack>,
IMatterPatternModifier<ItemStack> {
    public MemoryChipItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public int getPatternSlots(ItemStack element) {
        return 16;
    }

    @Override
    public List<MatterPattern> getPatterns(Level level, ItemStack element) {
        ArrayList<MatterPattern> items = new ArrayList<MatterPattern>();
        if (element.has(ReplicationAttachments.CHIP_PATTERNS)) {
            CompoundTag tag = (CompoundTag)element.get(ReplicationAttachments.CHIP_PATTERNS);
            for (int i = 0; i < this.getPatternSlots(element); ++i) {
                if (tag.contains("" + i)) {
                    MatterPattern pattern = new MatterPattern();
                    pattern.deserializeNBT((HolderLookup.Provider)level.registryAccess(), tag.getCompound("" + i));
                    items.add(pattern);
                    continue;
                }
                items.add(new MatterPattern());
            }
        }
        return items;
    }

    @Override
    @Nullable
    public IMatterPatternModifier.ModifierAction addPattern(Level level, ItemStack element, ItemStack stack, float progress) {
        List<MatterPattern> currentPatterns = this.getPatterns(level, element).stream().filter(pattern -> !pattern.getStack().isEmpty()).collect(Collectors.toList());
        for (MatterPattern currentPattern : currentPatterns) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)currentPattern.getStack(), (ItemStack)stack)) continue;
            currentPattern.setCompletion(Math.min(1.0f, currentPattern.getCompletion() + progress));
            this.savePatterns(level, element, currentPatterns);
            if (currentPattern.getCompletion() >= 1.0f && currentPatterns.size() >= this.getPatternSlots(element)) {
                return IMatterPatternModifier.ModifierAction.isFull(currentPattern);
            }
            return IMatterPatternModifier.ModifierAction.canKeepAdding(currentPattern);
        }
        if (currentPatterns.size() >= this.getPatternSlots(element)) {
            return IMatterPatternModifier.ModifierAction.isFull(null);
        }
        MatterPattern newPattern = new MatterPattern(stack, progress);
        currentPatterns.add(newPattern);
        this.savePatterns(level, element, currentPatterns);
        return IMatterPatternModifier.ModifierAction.canKeepAdding(newPattern);
    }

    @Override
    public void removePattern(Level level, ItemStack element, ItemStack stack) {
        List<MatterPattern> patterns = this.getPatterns(level, element).stream().filter(pattern -> !pattern.getStack().isEmpty()).filter(matterPattern -> !ItemStack.isSameItemSameComponents((ItemStack)matterPattern.getStack(), (ItemStack)stack)).toList();
        this.savePatterns(level, element, patterns);
    }

    private void savePatterns(Level level, ItemStack stack, List<MatterPattern> currentPatterns) {
        CompoundTag patterns = new CompoundTag();
        for (int i = 0; i < currentPatterns.size(); ++i) {
            patterns.put("" + i, (Tag)currentPatterns.get(i).serializeNBT((HolderLookup.Provider)level.registryAccess()));
        }
        stack.set(ReplicationAttachments.CHIP_PATTERNS, (Object)patterns);
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == BasicItem.Key.SHIFT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (key == BasicItem.Key.SHIFT) {
            int fullPatterns = 0;
            if (stack.has(ReplicationAttachments.CHIP_PATTERNS)) {
                List<MatterPattern> patterns = this.getPatterns((Level)Minecraft.getInstance().level, stack);
                for (MatterPattern pattern : patterns) {
                    if (pattern.getStack().isEmpty()) continue;
                    MutableComponent component = Component.literal((String)" - ").setStyle(Style.EMPTY.withColor(Mth.color((float)0.44705883f, (float)0.8980392f, (float)0.40392157f))).append((Component)Component.translatable((String)pattern.getStack().getDescriptionId()).withStyle(pattern.getCompletion() >= 1.0f ? ChatFormatting.GOLD : ChatFormatting.WHITE));
                    if (pattern.getCompletion() < 1.0f) {
                        component.append((Component)Component.literal((String)(" " + new DecimalFormat("##.## %").format(pattern.getCompletion()))).withStyle(Style.EMPTY.withColor(Mth.color((float)0.9490196f, (float)0.32156864f, (float)0.32156864f))));
                    }
                    tooltip.add((Component)component);
                    ++fullPatterns;
                }
            }
            if (fullPatterns < this.getPatternSlots(stack)) {
                tooltip.add((Component)Component.translatable((String)"tooltip.replication.memory_chip_slot", (Object[])new Object[]{Component.literal((String)String.valueOf(this.getPatternSlots(stack) - fullPatterns)).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.WHITE));
            }
        }
    }
}

