/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.gui;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.client.ClientReplicationCalculation;
import com.buuz135.replication.client.gui.ReplicationTerminalScreen;
import com.buuz135.replication.client.gui.button.ReplicationTerminalConfigButton;
import com.buuz135.replication.client.gui.button.ReplicationTerminalTexturedButton;
import com.buuz135.replication.container.ReplicationTerminalContainer;
import com.buuz135.replication.util.NumberUtils;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MatterOpediaTaskWidget
extends AbstractWidget
implements Renderable {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/gui/matteropedia.png");
    private static final ResourceLocation EXTRAS = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/gui/replication_terminal_extras.png");
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private final ReplicationTerminalScreen replicationTerminalScreen;
    private final ReplicationTerminalTexturedButton closeButton;
    private final int scrollBarX;
    private final int scrollBarY;
    private final int scrollBarWidth;
    private final int scrollBarHeight;
    private float scrollOffs;
    private boolean scrolling;
    private ReplicationTerminalConfigButton sortingType;
    private ReplicationTerminalConfigButton sortingDirection;
    private MatterValuesMenu matterValuesMenu;
    private EditBox searchBox;
    private IMatterType searchMatterType;
    private int searchMatterAmount = 0;
    private FilteringMode filteringMode = FilteringMode.NONE;

    public MatterOpediaTaskWidget(int pX, int pY, int pWidth, int pHeight, Component pMessage, ReplicationTerminalScreen replicationTerminalContainer, String defaultSearch) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.replicationTerminalScreen = replicationTerminalContainer;
        this.closeButton = new ReplicationTerminalTexturedButton(this.getX() + 176, this.getY() + 10, 9, 9, (Component)Component.empty(), EXTRAS, Component.translatable((String)"tooltip.replication.close").getString(), 247, 50, 238, 50, button -> this.replicationTerminalScreen.disableMatteropedia());
        this.widgets.add((AbstractWidget)this.closeButton);
        this.scrollOffs = 0.0f;
        this.scrolling = false;
        this.scrollBarX = this.getX() + this.width;
        this.scrollBarY = this.getY() + 23;
        this.scrollBarHeight = 88;
        this.scrollBarWidth = 9;
        this.searchMatterType = (IMatterType)ReplicationRegistry.Matter.EARTH.get();
        this.searchBox = new EditBox(Minecraft.getInstance().font, this.getX() + 85, this.getY() + 12, 79, 13, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(7529831);
        this.searchBox.setValue(defaultSearch);
        this.cacheMatterType();
        this.widgets.add((AbstractWidget)this.searchBox);
        this.sortingType = new ReplicationTerminalConfigButton(this.getX() + 10, this.getY() + 10, 9, 9, ReplicationTerminalScreen.BUTTONS, (LocatorInstance)new TileEntityLocatorInstance(((ReplicationTerminalContainer)replicationTerminalContainer.getMenu()).getPosition()), ReplicationTerminalConfigButton.Type.MATTEROPEDIA_TYPE, ((ReplicationTerminalContainer)replicationTerminalContainer.getMenu()).getMatterOpediaSortingType(), 247, 5, 238, 5){

            @Override
            public void onPress() {
                super.onPress();
                MatterOpediaTaskWidget.this.scrollOffs = 0.0f;
                MatterOpediaTaskWidget.this.matterValuesMenu.scrollTo(0.0f);
            }

            @Override
            protected void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                super.renderWidget(guiGraphics, pMouseX, pMouseY, pPartialTick);
            }
        };
        this.widgets.add((AbstractWidget)this.sortingType);
        this.sortingDirection = new ReplicationTerminalConfigButton(this.getX() + 20, this.getY() + 10, 9, 9, ReplicationTerminalScreen.BUTTONS, (LocatorInstance)new TileEntityLocatorInstance(((ReplicationTerminalContainer)replicationTerminalContainer.getMenu()).getPosition()), ReplicationTerminalConfigButton.Type.MATTEROPEDIA_DIRECTION, ((ReplicationTerminalContainer)replicationTerminalContainer.getMenu()).getMatterOpediaSortingValue(), 247, 23, 238, 23){

            @Override
            public void onPress() {
                super.onPress();
                MatterOpediaTaskWidget.this.scrollOffs = 0.0f;
                MatterOpediaTaskWidget.this.matterValuesMenu.scrollTo(0.0f);
            }

            @Override
            protected void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                super.renderWidget(guiGraphics, pMouseX, pMouseY, pPartialTick);
            }
        };
        this.widgets.add((AbstractWidget)this.sortingDirection);
        this.matterValuesMenu = new MatterValuesMenu();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"replication.matteropedia"), this.getX() + 98, this.getY() - 10, 7529831);
        guiGraphics.blit(TEXTURE, this.getX(), this.getY(), 0, 0, 195, 256);
        int j = this.getX() + 175;
        int k = this.getY() + 28;
        int i = k + 88;
        guiGraphics.blit(ReplicationTerminalScreen.BUTTONS, j, k + (int)((float)(i - k - 5) * this.scrollOffs), 245, 0, 11, 5);
        this.searchBox.render(guiGraphics, mouseX, mouseY, v);
        for (AbstractWidget abstractWidget : this.widgets) {
            abstractWidget.render(guiGraphics, mouseX, mouseY, v);
        }
        for (int index = 0; index < this.matterValuesMenu.visibleButtons.size(); ++index) {
            MatterDisplay matterDisplay = this.matterValuesMenu.visibleButtons.get(index);
            matterDisplay.render(guiGraphics, this.getX() + index % 9 * 18 + 9, this.getY() + index / 9 * 18 + 26, mouseX, mouseY, v);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected boolean insideScrollbar(double p_98524_, double p_98525_) {
        int i = this.getX();
        int j = this.getY();
        int k = i + 176;
        int l = j + 27;
        int i1 = k + 9;
        int j1 = l + 90;
        return p_98524_ >= (double)k && p_98525_ >= (double)l && p_98524_ < (double)i1 && p_98525_ < (double)j1;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            int i = this.scrollBarY + 1;
            int j = i + this.scrollBarHeight - 2;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.matterValuesMenu.scrollTo(this.scrollOffs);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double p_98527_, double p_98528_, double p_98529_, double scrollY) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrollOffs = this.matterValuesMenu.subtractInputFromScroll(this.scrollOffs, scrollY);
        this.matterValuesMenu.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    private boolean canScroll() {
        return this.matterValuesMenu.canScroll();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            if (this.insideScrollbar(pMouseX, pMouseY)) {
                this.scrolling = this.canScroll();
                int i = this.scrollBarY + 1;
                int j = i + this.scrollBarHeight - 2;
                this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
                this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
                this.matterValuesMenu.scrollTo(this.scrollOffs);
                return true;
            }
            if (this.searchBox.isHovered()) {
                this.searchBox.setFocused(true);
                return this.searchBox.mouseClicked(pMouseX, pMouseY, pButton);
            }
            this.searchBox.setFocused(false);
            if (this.closeButton.isHovered()) {
                return this.closeButton.mouseClicked(pMouseX, pMouseY, pButton);
            }
            if (this.sortingDirection.isHovered()) {
                return this.sortingDirection.mouseClicked(pMouseX, pMouseY, pButton);
            }
            if (this.sortingType.isHovered()) {
                return this.sortingType.mouseClicked(pMouseX, pMouseY, pButton);
            }
            if (this.matterValuesMenu.mouseClicked(pMouseX, pMouseY, pButton)) {
                return true;
            }
        }
        return false;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        String s = this.searchBox.getValue();
        if (this.searchBox.charTyped(pCodePoint, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.cacheMatterType();
                this.matterValuesMenu.scrollTo(0.0f);
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(int p_98547_, int p_98548_, int p_98549_) {
        if (p_98547_ == 256) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ReplicationRegistry.Sounds.TERMINAL_BUTTON.get()), (float)1.0f));
            this.replicationTerminalScreen.disableMatteropedia();
        }
        String s = this.searchBox.getValue();
        if (this.searchBox.keyPressed(p_98547_, p_98548_, p_98549_)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.cacheMatterType();
                this.matterValuesMenu.scrollTo(0.0f);
                return true;
            }
        } else {
            return this.searchBox.isFocused() && this.searchBox.isVisible() && p_98547_ != 256 || super.keyPressed(p_98547_, p_98548_, p_98549_);
        }
        return false;
    }

    private void cacheMatterType() {
        String s;
        String matterType = s = this.searchBox.getValue();
        this.searchMatterAmount = 0;
        if (s.contains("=")) {
            this.filteringMode = FilteringMode.AMOUNT_EQUAL;
            matterType = this.cleanString(s, "=");
        } else if (s.contains("<")) {
            this.filteringMode = FilteringMode.AMOUNT_LESS;
            matterType = this.cleanString(s, "<");
        } else if (s.contains(">")) {
            this.filteringMode = FilteringMode.AMOUNT_GREATER;
            matterType = this.cleanString(s, ">");
        } else if (s.startsWith("!")) {
            this.filteringMode = FilteringMode.DOESNT_HAVE;
            matterType = s.replaceFirst("!", "");
        } else if (s.startsWith("*")) {
            this.filteringMode = FilteringMode.ONLY_HAS;
            matterType = s.replaceFirst("\\*", "");
        } else {
            this.filteringMode = FilteringMode.NONE;
        }
        boolean found = false;
        for (IMatterType iMatterType : ReplicationRegistry.MATTER_TYPES_REGISTRY) {
            if (!Component.translatable((String)("replication.matter_type." + iMatterType.getName())).getString().toLowerCase().contains(matterType.toLowerCase())) continue;
            this.searchMatterType = iMatterType;
            found = true;
            break;
        }
        if (!found) {
            this.searchMatterType = (IMatterType)ReplicationRegistry.Matter.EARTH.get();
        }
    }

    private String cleanString(String input, String splitChar) {
        String[] split = input.split(splitChar);
        if (split.length == 2) {
            try {
                this.searchMatterAmount = Integer.parseInt(split[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return split[0];
        }
        return input;
    }

    public List<AbstractWidget> getWidgets() {
        return this.widgets;
    }

    public static enum FilteringMode {
        NONE,
        AMOUNT_EQUAL,
        AMOUNT_LESS,
        AMOUNT_GREATER,
        DOESNT_HAVE,
        ONLY_HAS;

    }

    public class MatterValuesMenu {
        public List<MatterDisplay> matterPatternButtonList = new ArrayList<MatterDisplay>();
        public List<MatterDisplay> visibleButtons = new ArrayList<MatterDisplay>();

        public MatterValuesMenu() {
            ClientReplicationCalculation.DEFAULT_MATTER_COMPOUND.forEach((s, matterCompound) -> {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)s));
                ItemStack stack = item.getDefaultInstance();
                if (!stack.isEmpty()) {
                    this.matterPatternButtonList.add(new MatterDisplay(stack, (MatterCompound)matterCompound));
                }
            });
            this.scrollTo(0.0f);
        }

        protected int calculateRowCount() {
            return Mth.positiveCeilDiv((int)this.getFilteredPatterns().size(), (int)9) - 7;
        }

        protected int getRowIndexForScroll(float p_259664_) {
            return Math.max((int)((double)(p_259664_ * (float)this.calculateRowCount()) + 0.5), 0);
        }

        protected float getScrollForRowIndex(int p_259315_) {
            return Mth.clamp((float)((float)p_259315_ / (float)this.calculateRowCount()), (float)0.0f, (float)1.0f);
        }

        protected float subtractInputFromScroll(float p_259841_, double p_260358_) {
            return Mth.clamp((float)(p_259841_ - (float)(p_260358_ / (double)this.calculateRowCount())), (float)0.0f, (float)1.0f);
        }

        public void scrollTo(float p_98643_) {
            int i = this.getRowIndexForScroll(p_98643_);
            this.visibleButtons = new ArrayList<MatterDisplay>();
            List<MatterDisplay> filtered = this.getFilteredPatterns();
            Comparator<MatterDisplay> comparator = Comparator.comparingDouble(matterDisplay -> matterDisplay.getAmountFor(MatterOpediaTaskWidget.this.searchMatterType));
            if (MatterOpediaTaskWidget.this.sortingType.getState() == 1) {
                comparator = Comparator.comparing(matterPatternButton -> matterPatternButton.getStack().getDisplayName().getString().toLowerCase());
                comparator = comparator.reversed();
            }
            if (MatterOpediaTaskWidget.this.sortingDirection.getState() == 1) {
                comparator = comparator.reversed();
            }
            filtered.sort(comparator);
            for (int j = 0; j < 7; ++j) {
                for (int k = 0; k < 9; ++k) {
                    int l = k + (j + i) * 9;
                    if (l < 0 || l >= filtered.size()) continue;
                    this.visibleButtons.add(filtered.get(l));
                }
            }
        }

        public boolean canScroll() {
            return this.getFilteredPatterns().size() > 63;
        }

        private List<MatterDisplay> getFilteredPatterns() {
            Stream<Object> list = this.matterPatternButtonList.stream();
            if (MatterOpediaTaskWidget.this.filteringMode == FilteringMode.NONE) {
                list = list.filter(matterPatternButton -> matterPatternButton.getAmountFor(MatterOpediaTaskWidget.this.searchMatterType) > 0.0);
            } else if (MatterOpediaTaskWidget.this.filteringMode == FilteringMode.AMOUNT_EQUAL) {
                list = list.filter(matterPatternButton -> matterPatternButton.getAmountFor(MatterOpediaTaskWidget.this.searchMatterType) == (double)MatterOpediaTaskWidget.this.searchMatterAmount);
            } else if (MatterOpediaTaskWidget.this.filteringMode == FilteringMode.AMOUNT_LESS) {
                list = list.filter(matterPatternButton -> matterPatternButton.getAmountFor(MatterOpediaTaskWidget.this.searchMatterType) < (double)MatterOpediaTaskWidget.this.searchMatterAmount);
            } else if (MatterOpediaTaskWidget.this.filteringMode == FilteringMode.AMOUNT_GREATER) {
                list = list.filter(matterPatternButton -> matterPatternButton.getAmountFor(MatterOpediaTaskWidget.this.searchMatterType) > (double)MatterOpediaTaskWidget.this.searchMatterAmount);
            } else if (MatterOpediaTaskWidget.this.filteringMode == FilteringMode.ONLY_HAS) {
                list = list.filter(matterPatternButton -> matterPatternButton.getAmountFor(MatterOpediaTaskWidget.this.searchMatterType) > 0.0 && matterPatternButton.getMatterCompound().getValues().size() == 1);
            } else if (MatterOpediaTaskWidget.this.filteringMode == FilteringMode.DOESNT_HAVE) {
                list = list.filter(matterPatternButton -> matterPatternButton.getAmountFor(MatterOpediaTaskWidget.this.searchMatterType) == 0.0);
            }
            return list.collect(Collectors.toList());
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            return false;
        }
    }

    public class MatterDisplay {
        private ItemStack stack;
        private MatterCompound matterCompound;

        public MatterDisplay(ItemStack stack, MatterCompound values) {
            this.stack = stack;
            this.matterCompound = values;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public MatterCompound getMatterCompound() {
            return this.matterCompound;
        }

        public double getAmountFor(IMatterType type) {
            if (this.matterCompound.getValues().containsKey(type)) {
                return this.matterCompound.getValues().get(type).getAmount();
            }
            return 0.0;
        }

        public void render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float v) {
            guiGraphics.renderItem(this.stack, x + 2, y + 2);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            float scale = 0.5f;
            double amount = this.getAmountFor(MatterOpediaTaskWidget.this.searchMatterType);
            if (amount > 0.0) {
                String display = NumberUtils.getFormatedBigNumber(amount);
                guiGraphics.pose().scale(scale, scale, scale);
                guiGraphics.drawString(Minecraft.getInstance().font, display, (float)(x + 18) / scale - (float)Minecraft.getInstance().font.width(display), (float)(y + 14) / scale, 0xFFFFFF, true);
            }
            guiGraphics.pose().popPose();
            if (mouseX > x + 2 && mouseX < x + 19 && mouseY > y + 2 && mouseY < y + 19) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, this.stack, mouseX, mouseY);
            }
        }
    }
}

