/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.event.v1.gui;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public final class RenderGuiLayerEvents {
    private static final List<ResourceLocation> VANILLA_GUI_LAYERS = new ArrayList<ResourceLocation>();
    public static final List<ResourceLocation> VANILLA_GUI_LAYERS_VIEW = Collections.unmodifiableList(VANILLA_GUI_LAYERS);
    public static final ResourceLocation CAMERA_OVERLAYS = RenderGuiLayerEvents.register("camera_overlays");
    public static final ResourceLocation CROSSHAIR = RenderGuiLayerEvents.register("crosshair");
    public static final ResourceLocation HOTBAR = RenderGuiLayerEvents.register("hotbar");
    public static final ResourceLocation JUMP_METER = RenderGuiLayerEvents.register("jump_meter");
    public static final ResourceLocation EXPERIENCE_BAR = RenderGuiLayerEvents.register("experience_bar");
    public static final ResourceLocation PLAYER_HEALTH = RenderGuiLayerEvents.register("player_health");
    public static final ResourceLocation ARMOR_LEVEL = RenderGuiLayerEvents.register("armor_level");
    public static final ResourceLocation FOOD_LEVEL = RenderGuiLayerEvents.register("food_level");
    public static final ResourceLocation VEHICLE_HEALTH = RenderGuiLayerEvents.register("vehicle_health");
    public static final ResourceLocation AIR_LEVEL = RenderGuiLayerEvents.register("air_level");
    public static final ResourceLocation SELECTED_ITEM_NAME = RenderGuiLayerEvents.register("selected_item_name");
    public static final ResourceLocation SPECTATOR_TOOLTIP = RenderGuiLayerEvents.register("spectator_tooltip");
    public static final ResourceLocation EXPERIENCE_LEVEL = RenderGuiLayerEvents.register("experience_level");
    public static final ResourceLocation EFFECTS = RenderGuiLayerEvents.register("effects");
    public static final ResourceLocation BOSS_OVERLAY = RenderGuiLayerEvents.register("boss_overlay");
    public static final ResourceLocation SLEEP_OVERLAY = RenderGuiLayerEvents.register("sleep_overlay");
    public static final ResourceLocation DEMO_OVERLAY = RenderGuiLayerEvents.register("demo_overlay");
    public static final ResourceLocation DEBUG_OVERLAY = RenderGuiLayerEvents.register("debug_overlay");
    public static final ResourceLocation SCOREBOARD_SIDEBAR = RenderGuiLayerEvents.register("scoreboard_sidebar");
    public static final ResourceLocation OVERLAY_MESSAGE = RenderGuiLayerEvents.register("overlay_message");
    public static final ResourceLocation TITLE = RenderGuiLayerEvents.register("title");
    public static final ResourceLocation CHAT = RenderGuiLayerEvents.register("chat");
    public static final ResourceLocation TAB_LIST = RenderGuiLayerEvents.register("tab_list");
    public static final ResourceLocation SUBTITLE_OVERLAY = RenderGuiLayerEvents.register("subtitle_overlay");
    public static final ResourceLocation SAVING_INDICATOR = RenderGuiLayerEvents.register("saving_indicator");

    private RenderGuiLayerEvents() {
    }

    public static EventInvoker<Before> before(ResourceLocation resourceLocation) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        return EventInvoker.lookup(Before.class, resourceLocation);
    }

    public static EventInvoker<After> after(ResourceLocation resourceLocation) {
        Objects.requireNonNull(resourceLocation, "resource location is null");
        return EventInvoker.lookup(After.class, resourceLocation);
    }

    private static ResourceLocation register(String path) {
        return RenderGuiLayerEvents.register(ResourceLocationHelper.withDefaultNamespace(path));
    }

    private static ResourceLocation register(ResourceLocation resourceLocation) {
        VANILLA_GUI_LAYERS.add(resourceLocation);
        return resourceLocation;
    }

    @FunctionalInterface
    public static interface Before {
        public EventResult onBeforeRenderGuiLayer(Minecraft var1, GuiGraphics var2, DeltaTracker var3);
    }

    @FunctionalInterface
    public static interface After {
        public void onAfterRenderGuiLayer(Minecraft var1, GuiGraphics var2, DeltaTracker var3);
    }
}

