/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickCollapseBlock
extends PieceTrick {
    SpellParam<Vector3> position;

    public PieceTrickCollapseBlock(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(80.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(125.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 80);
        meta.addStat(EnumSpellStat.COST, 125);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        ItemStack tool = context.getHarvestTool();
        Vector3 positionVal = this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector", new Object[0]);
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius", new Object[0]);
        }
        Level world = context.focalPoint.getCommandSenderWorld();
        BlockPos pos = positionVal.toBlockPos();
        BlockPos posDown = pos.below();
        BlockState state = world.getBlockState(pos);
        BlockState stateDown = world.getBlockState(posDown);
        if (!world.mayInteract(context.caster, pos)) {
            return null;
        }
        if (stateDown.isAir() && state.getDestroySpeed((BlockGetter)world, pos) != -1.0f && PieceTrickBreakBlock.canHarvestBlock(state, context.caster, world, pos, tool) && world.getBlockEntity(pos) == null) {
            BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, world, pos);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return null;
            }
            FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)state);
        }
        return null;
    }
}

