/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.exosuit.ISensorHoldable;
import vazkii.psi.common.crafting.ModCraftingRecipes;

public class SensorRemoveRecipe
extends CustomRecipe {
    public SensorRemoveRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level world) {
        boolean foundHoldable = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (!foundHoldable && stack.getItem() instanceof ISensorHoldable && !((ISensorHoldable)stack.getItem()).getAttachedSensor(stack).isEmpty()) {
                foundHoldable = true;
                continue;
            }
            return false;
        }
        return foundHoldable;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, HolderLookup.Provider pRegistries) {
        ItemStack holdableItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            holdableItem = stack;
        }
        ItemStack copy = holdableItem.copy();
        ISensorHoldable holdable = (ISensorHoldable)holdableItem.getItem();
        holdable.attachSensor(copy, ItemStack.EMPTY);
        return copy;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList list = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.getItem(i);
            if (!(item.getItem() instanceof ISensorHoldable)) continue;
            list.set(i, (Object)((ISensorHoldable)item.getItem()).getAttachedSensor(item));
            break;
        }
        return list;
    }

    @NotNull
    public RecipeType<?> getType() {
        return !DatagenModLoader.isRunningDataGen() ? RecipeType.CRAFTING : (RecipeType)ModCraftingRecipes.SENSOR_REMOVE_TYPE.get();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModCraftingRecipes.SENSOR_REMOVE_SERIALIZER.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }
}

