/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.RegenPsiEvent;
import vazkii.psi.api.exosuit.IPsiEventArmor;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.LoopcastEndEvent;
import vazkii.psi.api.spell.PieceExecutedEvent;
import vazkii.psi.api.spell.PieceGroupAdvancementComplete;
import vazkii.psi.api.spell.PieceKnowledgeEvent;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.client.render.entity.RenderSpellCircle;
import vazkii.psi.common.Psi;
import vazkii.psi.common.attribute.base.ModAttributes;
import vazkii.psi.common.core.handler.LoopcastTrackingHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.lib.LibResources;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageDataSync;
import vazkii.psi.common.network.message.MessageDeductPsi;
import vazkii.psi.common.network.message.MessagePsiOverflow;
import vazkii.psi.common.network.message.MessageTriggerJumpSpell;

public class PlayerDataHandler {
    public static final Set<SpellContext> delayedContexts = new LinkedHashSet<SpellContext>();
    private static final WeakHashMap<Player, PlayerData> remotePlayerData = new WeakHashMap();
    private static final WeakHashMap<Player, PlayerData> playerData = new WeakHashMap();
    private static final String DATA_TAG = "PsiData";

    @NotNull
    public static PlayerData get(Player player) {
        if (player == null) {
            return new PlayerData();
        }
        WeakHashMap<Player, PlayerData> dataMap = player.level().isClientSide ? remotePlayerData : playerData;
        PlayerData data = dataMap.computeIfAbsent(player, PlayerData::new);
        if (data.playerWR != null && data.playerWR.get() != player) {
            CompoundTag cmp = new CompoundTag();
            data.writeToNBT(cmp);
            dataMap.remove(player);
            data = PlayerDataHandler.get(player);
            data.readFromNBT(cmp);
        }
        return data;
    }

    public static CompoundTag getDataCompoundForPlayer(Player player) {
        CompoundTag persistentData;
        CompoundTag forgeData = player.getPersistentData();
        if (!forgeData.contains("PlayerPersisted")) {
            forgeData.put("PlayerPersisted", (Tag)new CompoundTag());
        }
        if (!(persistentData = forgeData.getCompound("PlayerPersisted")).contains(DATA_TAG)) {
            persistentData.put(DATA_TAG, (Tag)new CompoundTag());
        }
        return persistentData.getCompound(DATA_TAG);
    }

    public static class PlayerData
    implements IPlayerData {
        private static final String TAG_AVAILABLE_PSI = "availablePsi";
        private static final String TAG_REGEN_CD = "regenCd";
        private static final String TAG_OVERFLOWED = "overflowed";
        private static final String TAG_EIDOS_ANCHOR_X = "eidosAnchorX";
        private static final String TAG_EIDOS_ANCHOR_Y = "eidosAnchorY";
        private static final String TAG_EIDOS_ANCHOR_Z = "eidosAnchorZ";
        private static final String TAG_EIDOS_ANCHOR_PITCH = "eidosAnchorPitch";
        private static final String TAG_EIDOS_ANCHOR_YAW = "eidosAnchorYaw";
        private static final String TAG_EIDOS_ANCHOR_TIME = "eidosAnchorTime";
        private static final String TAG_CUSTOM_DATA = "customData";
        public final Stack<Vector3> eidosChangelog = new Stack();
        public final List<Deduction> deductions = new ArrayList<Deduction>();
        public final WeakReference<Player> playerWR;
        private final boolean client;
        public int availablePsi;
        public int lastAvailablePsi;
        public int regenCooldown;
        public boolean loopcasting = false;
        public InteractionHand loopcastHand = null;
        public ItemStack lastTickLoopcastStack;
        public int loopcastTime = 1;
        public int loopcastAmount = 0;
        public int loopcastFadeTime = 0;
        public boolean overflowed = false;
        public Vector3 eidosAnchor = new Vector3(0.0, 0.0, 0.0);
        public double eidosAnchorPitch;
        public double eidosAnchorYaw;
        public boolean isAnchored;
        public boolean isReverting;
        public int eidosAnchorTime;
        public int postAnchorRecallTime;
        public int eidosReversionTime;
        public DimensionType lastDimension;
        public boolean deductTick;
        private boolean lowLight;
        private boolean underwater;
        private boolean lowHp;
        private CompoundTag customData;

        private PlayerData() {
            this.playerWR = new WeakReference<Object>(null);
            this.client = true;
        }

        public PlayerData(Player player) {
            this.playerWR = new WeakReference<Player>(player);
            this.client = player.getCommandSenderWorld().isClientSide;
            this.load();
        }

        /*
         * Unable to fully structure code
         */
        public void tick() {
            block45: {
                block43: {
                    block49: {
                        block46: {
                            block48: {
                                block47: {
                                    block44: {
                                        player = (Player)this.playerWR.get();
                                        if (player == null) {
                                            return;
                                        }
                                        dimension = player.getCommandSenderWorld().dimensionType();
                                        if (this.deductTick) {
                                            this.deductTick = false;
                                        } else {
                                            this.lastAvailablePsi = this.availablePsi;
                                        }
                                        max = this.getTotalPsi();
                                        if (this.availablePsi > max) {
                                            this.availablePsi = max;
                                        }
                                        if (!(cadStack = this.getCAD()).isEmpty()) {
                                            cad = (ICAD)cadStack.getItem();
                                            overflow = cad.getStatValue(cadStack, EnumCADStat.OVERFLOW);
                                            if (overflow == -1) {
                                                this.availablePsi = max;
                                            } else {
                                                this.applyRegen(player, max, cadStack);
                                            }
                                        } else {
                                            this.applyRegen(player, max, cadStack);
                                        }
                                        color = -15481345;
                                        if (!cadStack.isEmpty()) {
                                            color = Psi.proxy.getColorForCAD(cadStack);
                                        }
                                        r = (float)PsiRenderHelper.r(color) / 255.0f;
                                        g = (float)PsiRenderHelper.g(color) / 255.0f;
                                        b = (float)PsiRenderHelper.b(color) / 255.0f;
                                        if (player.isSpectator()) {
                                            this.stopLoopcast();
                                        }
                                        if (this.overflowed) {
                                            this.stopLoopcast();
                                        }
                                        if (!this.loopcasting || this.loopcastHand == null) break block43;
                                        stackInHand = player.getItemInHand(this.loopcastHand);
                                        if (!stackInHand.isEmpty() && ISocketable.isSocketable(stackInHand) && ISocketable.socketable(stackInHand).canLoopcast()) break block44;
                                        this.stopLoopcast();
                                        break block45;
                                    }
                                    if (this.lastTickLoopcastStack == null) break block46;
                                    if (ItemStack.isSameItem((ItemStack)this.lastTickLoopcastStack, (ItemStack)stackInHand) && ISocketable.isSocketable(this.lastTickLoopcastStack)) break block47;
                                    this.stopLoopcast();
                                    break block45;
                                }
                                lastTickItem = ISocketable.socketable(this.lastTickLoopcastStack);
                                thisTickItem = ISocketable.socketable(stackInHand);
                                lastSlot = lastTickItem.getSelectedSlot();
                                if (lastSlot == (thisSlot = thisTickItem.getSelectedSlot())) break block48;
                                this.stopLoopcast();
                                break block45;
                            }
                            lastTick = lastTickItem.getBulletInSocket(lastSlot);
                            if (ItemStack.matches((ItemStack)lastTick, (ItemStack)(thisTick = thisTickItem.getBulletInSocket(thisSlot)))) break block46;
                            this.stopLoopcast();
                            break block45;
                        }
                        this.lastTickLoopcastStack = stackInHand.copy();
                        socketable = ISocketable.socketable(stackInHand);
                        for (i = 0; i < 5; ++i) {
                            x = player.getX() + (Math.random() - 0.5) * 2.1 * (double)player.getBbWidth();
                            y = player.getY() + 0.35;
                            z = player.getZ() + (Math.random() - 0.5) * 2.1 * (double)player.getBbWidth();
                            grav = -0.15f - (float)Math.random() * 0.03f;
                            Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
                        }
                        if (this.loopcastTime <= 0 || this.loopcastTime % 5 != 0) ** GOTO lbl84
                        bullet = socketable.getSelectedBullet();
                        if (!bullet.isEmpty() && ISpellAcceptor.hasSpell(bullet)) break block49;
                        this.stopLoopcast();
                        break block45;
                    }
                    spellContainer = ISpellAcceptor.acceptor(bullet);
                    spell = spellContainer.getSpell();
                    context = new SpellContext().setPlayer(player).setSpell(spell).setLoopcastIndex(this.loopcastAmount + 1);
                    context.castFrom = this.loopcastHand;
                    if (!context.isValid() || !context.cspell.metadata.evaluateAgainst(cadStack)) ** GOTO lbl84
                    cost = ItemCAD.getRealCost(cadStack, bullet, context.cspell.metadata.getStat(EnumSpellStat.COST));
                    if (cost > 0 || cost == -1) {
                        if (cost != -1) {
                            this.deductPsi(cost, 0, true);
                        }
                        if (!player.getCommandSenderWorld().isClientSide && this.loopcastTime % 10 == 0) {
                            player.getCommandSenderWorld().playSound(null, player.getX(), player.getY(), player.getZ(), PsiSoundHandler.loopcast, SoundSource.PLAYERS, 0.1f, (float)(0.15 + Math.random() * 0.85));
                        }
                    }
                    if (!player.getCommandSenderWorld().isClientSide && !spellContainer.loopcastSpell(context)) {
                        this.stopLoopcast();
                    } else {
                        ++this.loopcastAmount;
lbl84:
                        // 3 sources

                        ++this.loopcastTime;
                    }
                    break block45;
                }
                if (this.loopcastFadeTime > 0) {
                    --this.loopcastFadeTime;
                }
            }
            if (!player.isAlive() || dimension != this.lastDimension) {
                this.eidosAnchorTime = 0;
                this.eidosReversionTime = 0;
                this.eidosChangelog.clear();
                this.isAnchored = false;
                this.isReverting = false;
            }
            if (this.eidosAnchorTime > 0) {
                if (this.eidosAnchorTime == 1) {
                    if (player instanceof ServerPlayer) {
                        pmp = (ServerPlayer)player;
                        pmp.connection.teleport(this.eidosAnchor.x, this.eidosAnchor.y, this.eidosAnchor.z, (float)this.eidosAnchorYaw, (float)this.eidosAnchorPitch);
                        for (riding = player.getVehicle(); riding != null; riding = riding.getVehicle()) {
                            riding.setPos(this.eidosAnchor.x, this.eidosAnchor.y, this.eidosAnchor.z);
                        }
                    }
                    this.postAnchorRecallTime = 0;
                }
                --this.eidosAnchorTime;
            } else if (this.postAnchorRecallTime < 5) {
                --this.postAnchorRecallTime;
                this.isAnchored = false;
            }
            if (this.eidosReversionTime > 0) {
                if (this.eidosChangelog.isEmpty()) {
                    this.eidosReversionTime = 0;
                    this.isReverting = false;
                } else {
                    this.eidosChangelog.pop();
                    if (this.eidosChangelog.isEmpty()) {
                        this.eidosReversionTime = 0;
                        this.isReverting = false;
                    } else {
                        vec = this.eidosChangelog.pop();
                        if (player instanceof ServerPlayer) {
                            pmp = (ServerPlayer)player;
                            pmp.connection.teleport(vec.x, vec.y, vec.z, 0.0f, 0.0f, (Set)ImmutableSet.of((Object)RelativeMovement.X_ROT, (Object)RelativeMovement.Y_ROT));
                            pmp.connection.resetPosition();
                        } else {
                            player.setPos(vec.x, vec.y, vec.z);
                        }
                        for (riding = player.getVehicle(); riding != null; riding = riding.getVehicle()) {
                            riding.setPos(vec.x, vec.y, vec.z);
                        }
                        if (player.level().isClientSide) {
                            for (i = 0; i < 5; ++i) {
                                spread = 0.6;
                                x = player.getX() + (Math.random() - 0.5) * spread;
                                y = player.getY() + (Math.random() - 0.5) * spread;
                                z = player.getZ() + (Math.random() - 0.5) * spread;
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, 0.0f, 0.0f, 0.0f, 1.2f, 12);
                            }
                        }
                        player.setDeltaMovement(0.0, 0.0, 0.0);
                        player.fallDistance = 0.0f;
                    }
                }
                --this.eidosReversionTime;
                if (this.eidosReversionTime == 0 || player.isShiftKeyDown()) {
                    this.eidosChangelog.clear();
                    this.isReverting = false;
                }
            } else {
                if (this.eidosChangelog.size() > 600) {
                    this.eidosChangelog.removeFirst();
                }
                this.eidosChangelog.push(Vector3.fromEntity((Entity)player));
            }
            pos = player.blockPosition();
            light = player.getCommandSenderWorld().getLightEngine().getRawBrightness(pos, 0);
            v0 = lowLight = light == 0;
            if (!this.lowLight && lowLight) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.low_light"));
            }
            this.lowLight = lowLight;
            underwater = player.isInWater();
            if (!this.underwater && underwater) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.underwater"));
            }
            this.underwater = underwater;
            v1 = lowHp = player.getHealth() <= 6.0f;
            if (!this.lowHp && lowHp) {
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.low_hp"));
            }
            this.lowHp = lowHp;
            remove = new ArrayList<Deduction>();
            for (Deduction d : this.deductions) {
                if (d.invalid) {
                    remove.add(d);
                    continue;
                }
                d.tick();
            }
            this.deductions.removeAll(remove);
            this.lastDimension = dimension;
        }

        private void applyRegen(Player player, int max, ItemStack cadStack) {
            RegenPsiEvent event = new RegenPsiEvent(player, this, cadStack);
            if (!((RegenPsiEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                if (!cadStack.isEmpty()) {
                    ICAD cad = (ICAD)cadStack.getItem();
                    cad.regenPsi(cadStack, event.getCadRegen());
                }
                boolean anyChange = this.availablePsi != max && event.getPlayerRegen() > 0;
                int prevPsi = this.availablePsi;
                this.availablePsi = Math.min(max, this.availablePsi + event.getPlayerRegen());
                if (this.overflowed && event.willHealOverflow()) {
                    anyChange = true;
                    this.overflowed = false;
                }
                if (this.regenCooldown != event.getRegenCooldown()) {
                    anyChange = true;
                }
                this.regenCooldown = event.getRegenCooldown();
                if (anyChange) {
                    if (player instanceof ServerPlayer) {
                        MessageDeductPsi message = new MessageDeductPsi(prevPsi, this.availablePsi, this.regenCooldown, false);
                        MessageRegister.sendToPlayer((ServerPlayer)player, message);
                    }
                    this.save();
                }
            }
        }

        public void stopLoopcast() {
            Player player = (Player)this.playerWR.get();
            if (this.loopcasting) {
                this.loopcastFadeTime = 5;
                NeoForge.EVENT_BUS.post((Event)new LoopcastEndEvent(player, this, this.loopcastHand, this.loopcastAmount));
            }
            this.loopcasting = false;
            this.lastTickLoopcastStack = null;
            this.loopcastHand = null;
            this.loopcastTime = 1;
            this.loopcastAmount = 0;
            if (player instanceof ServerPlayer) {
                LoopcastTrackingHandler.syncForTrackersAndSelf((ServerPlayer)player);
            }
        }

        public int calculateDamageDeduction(float amount) {
            return (int)((double)this.getTotalPsi() * 0.02 * (double)amount);
        }

        public void damage(float amount) {
            int psi = this.calculateDamageDeduction(amount);
            if (psi > 0 && this.availablePsi > 0) {
                psi = Math.min(psi, this.availablePsi);
                this.deductPsi(psi, 20, true, true);
            }
        }

        public ItemStack getCAD() {
            return PsiAPI.getPlayerCAD((Player)this.playerWR.get());
        }

        public void deductPsi(int psi, int cd, boolean sync) {
            this.deductPsi(psi, cd, sync, false);
        }

        @Override
        public void deductPsi(int psi, int cd, boolean sync, boolean shatter) {
            ICAD cad;
            int storedPsi;
            int currentPsi = this.availablePsi;
            Player player = (Player)this.playerWR.get();
            if (player == null) {
                return;
            }
            ItemStack cadStack = this.getCAD();
            if (!cadStack.isEmpty() && (storedPsi = (cad = (ICAD)cadStack.getItem()).getStoredPsi(cadStack)) == -1) {
                return;
            }
            this.availablePsi -= psi;
            if (this.regenCooldown < cd) {
                this.regenCooldown = cd;
            }
            if (this.availablePsi < 0) {
                int overflow = -this.availablePsi;
                this.availablePsi = 0;
                if (!cadStack.isEmpty()) {
                    ICAD cad2 = (ICAD)cadStack.getItem();
                    overflow = cad2.consumePsi(cadStack, overflow);
                }
                if (!shatter && overflow > 0) {
                    float dmg = (float)overflow / (float)(this.loopcasting ? 50 : 125);
                    if (!this.client) {
                        Registry types = player.damageSources().damageTypes;
                        DamageSource overloadSource = new DamageSource((Holder)types.getHolderOrThrow(LibResources.PSI_OVERLOAD));
                        player.hurt(overloadSource, dmg);
                    }
                    this.overflowed = true;
                    if (sync && player instanceof ServerPlayer) {
                        MessagePsiOverflow message = new MessagePsiOverflow(true);
                        MessageRegister.sendToPlayer((ServerPlayer)player, message);
                    }
                }
            }
            if (sync && player instanceof ServerPlayer) {
                MessageDeductPsi message = new MessageDeductPsi(currentPsi, this.availablePsi, this.regenCooldown, shatter);
                MessageRegister.sendToPlayer((ServerPlayer)player, message);
            }
            this.save();
        }

        public void addDeduction(int current, int deduct, boolean shatter) {
            if (deduct > current) {
                deduct = current;
            }
            if (deduct < 0) {
                deduct = 0;
            }
            if (deduct == 0) {
                return;
            }
            this.deductions.add(new Deduction(current, deduct, 20, shatter));
        }

        @Override
        public int getAvailablePsi() {
            return this.availablePsi;
        }

        @Override
        public int getLastAvailablePsi() {
            return this.lastAvailablePsi;
        }

        @Override
        public int getTotalPsi() {
            Player player = (Player)this.playerWR.get();
            if (player != null) {
                return (int)player.getAttributeValue(ModAttributes.TOTAL_PSI);
            }
            return (int)((Attribute)ModAttributes.TOTAL_PSI.get()).getDefaultValue();
        }

        @Override
        public int getRegenPerTick() {
            Player player = (Player)this.playerWR.get();
            if (player != null) {
                return (int)player.getAttributeValue(ModAttributes.REGEN);
            }
            return (int)((Attribute)ModAttributes.REGEN.get()).getDefaultValue();
        }

        @Override
        public boolean isOverflowed() {
            return this.overflowed;
        }

        @Override
        public int getRegenCooldown() {
            return this.regenCooldown;
        }

        public boolean hasAdvancement(ResourceLocation group) {
            Player player = (Player)this.playerWR.get();
            return Psi.proxy.hasAdvancement(group, player);
        }

        @Override
        public boolean isPieceGroupUnlocked(ResourceLocation group, @Nullable ResourceLocation name) {
            Player player = (Player)this.playerWR.get();
            if (player == null) {
                return false;
            }
            if (player.isCreative()) {
                return true;
            }
            boolean hasAdvancement = this.hasAdvancement(group);
            PieceKnowledgeEvent event = new PieceKnowledgeEvent(group, name, player, this, hasAdvancement);
            NeoForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }

        @Override
        public void unlockPieceGroup(ResourceLocation resourceLocation) {
            Player player = (Player)this.playerWR.get();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.getServer() == null) {
                    return;
                }
                AdvancementHolder advancement = serverPlayer.getServer().getAdvancements().get(resourceLocation);
                if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                    for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                        serverPlayer.getAdvancements().getOrStartProgress(advancement).grantProgress(s);
                    }
                }
            }
        }

        @Override
        public void markPieceExecuted(SpellPiece piece) {
            Player player = (Player)this.playerWR.get();
            if (player == null) {
                return;
            }
            PieceExecutedEvent event = new PieceExecutedEvent(piece, player);
            NeoForge.EVENT_BUS.post((Event)event);
            Optional<Map.Entry> advancementEntry = PsiAPI.ADVANCEMENT_GROUP_REGISTRY.entrySet().stream().filter(entry -> ((Collection)entry.getValue()).contains(piece.getClass())).findFirst();
            if (advancementEntry.isEmpty()) {
                return;
            }
            ResourceLocation advancement = ((ResourceKey)advancementEntry.get().getKey()).location();
            Object advancementMainPieceClass = ((Collection)advancementEntry.get().getValue()).toArray()[0];
            if (advancementMainPieceClass == piece.getClass() && !this.hasAdvancement(advancement)) {
                NeoForge.EVENT_BUS.post((Event)new PieceGroupAdvancementComplete(piece, player, advancement));
            }
        }

        @Override
        public CompoundTag getCustomData() {
            if (this.customData == null) {
                this.customData = new CompoundTag();
                return this.customData;
            }
            return this.customData;
        }

        @Override
        public void save() {
            Player player;
            if (!this.client && (player = (Player)this.playerWR.get()) != null) {
                CompoundTag cmp = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.writeToNBT(cmp);
            }
        }

        public void writeToNBT(CompoundTag cmp) {
            cmp.putInt(TAG_AVAILABLE_PSI, this.availablePsi);
            cmp.putInt(TAG_REGEN_CD, this.regenCooldown);
            cmp.putBoolean(TAG_OVERFLOWED, this.overflowed);
            cmp.putDouble(TAG_EIDOS_ANCHOR_X, this.eidosAnchor.x);
            cmp.putDouble(TAG_EIDOS_ANCHOR_Y, this.eidosAnchor.y);
            cmp.putDouble(TAG_EIDOS_ANCHOR_Z, this.eidosAnchor.z);
            cmp.putDouble(TAG_EIDOS_ANCHOR_PITCH, this.eidosAnchorPitch);
            cmp.putDouble(TAG_EIDOS_ANCHOR_YAW, this.eidosAnchorYaw);
            cmp.putInt(TAG_EIDOS_ANCHOR_TIME, this.eidosAnchorTime);
            if (this.customData != null) {
                cmp.put(TAG_CUSTOM_DATA, (Tag)this.customData);
            }
        }

        public void load() {
            Player player;
            if (!this.client && (player = (Player)this.playerWR.get()) != null) {
                CompoundTag cmp = PlayerDataHandler.getDataCompoundForPlayer(player);
                this.readFromNBT(cmp);
            }
        }

        public void readFromNBT(CompoundTag cmp) {
            this.availablePsi = cmp.getInt(TAG_AVAILABLE_PSI);
            this.regenCooldown = cmp.getInt(TAG_REGEN_CD);
            this.overflowed = cmp.getBoolean(TAG_OVERFLOWED);
            double x = cmp.getDouble(TAG_EIDOS_ANCHOR_X);
            double y = cmp.getDouble(TAG_EIDOS_ANCHOR_X);
            double z = cmp.getDouble(TAG_EIDOS_ANCHOR_X);
            this.eidosAnchor.set(x, y, z);
            this.eidosAnchorPitch = cmp.getDouble(TAG_EIDOS_ANCHOR_PITCH);
            this.eidosAnchorYaw = cmp.getDouble(TAG_EIDOS_ANCHOR_YAW);
            this.eidosAnchorTime = cmp.getInt(TAG_EIDOS_ANCHOR_TIME);
            this.customData = cmp.getCompound(TAG_CUSTOM_DATA);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(Player player, float partTicks, PoseStack ms) {
            Item item;
            EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
            double x = player.xOld + (player.getX() - player.xOld) * (double)partTicks - renderManager.camera.getPosition().x;
            double y = player.yOld + (player.getY() - player.yOld) * (double)partTicks - renderManager.camera.getPosition().y;
            double z = player.zOld + (player.getZ() - player.zOld) * (double)partTicks - renderManager.camera.getPosition().z;
            float scale = 0.75f;
            if (this.loopcasting) {
                mul = Math.min(5.0f, (float)this.loopcastTime + partTicks) / 5.0f;
                scale *= mul;
            } else if (this.loopcastFadeTime > 0) {
                mul = Math.min(5.0f, (float)this.loopcastFadeTime - partTicks) / 5.0f;
                scale *= mul;
            } else {
                return;
            }
            int color = -15481345;
            ItemStack cad = PsiAPI.getPlayerCAD((Player)this.playerWR.get());
            if (!cad.isEmpty() && (item = cad.getItem()) instanceof ICAD) {
                ICAD icad = (ICAD)item;
                color = icad.getSpellColor(cad);
            }
            ms.pushPose();
            ms.translate(x, y + 0.15, z);
            MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderSpellCircle.renderSpellCircle((float)ClientTickHandler.ticksInGame + partTicks, scale, 1.0f, 0.0f, -1.0f, 0.0f, color, ms, (MultiBufferSource)buffers);
            buffers.endBatch();
            ms.popPose();
        }

        public static class Deduction {
            public final int current;
            public final int deduct;
            public final int cd;
            public final boolean shatter;
            public int elapsed;
            public boolean invalid;

            public Deduction(int current, int deduct, int cd, boolean shatter) {
                this.current = current;
                this.deduct = deduct;
                this.cd = cd;
                this.shatter = shatter;
            }

            public void tick() {
                ++this.elapsed;
                if (this.elapsed >= this.cd) {
                    this.invalid = true;
                }
            }

            public float getPercentile(float partTicks) {
                return 1.0f - Math.min(1.0f, ((float)this.elapsed + partTicks) / (float)this.cd);
            }
        }
    }

    @EventBusSubscriber(modid="psi")
    public static class EventHandler {
        @SubscribeEvent
        public static void onServerTick(ServerTickEvent.Post event) {
            ArrayList<SpellContext> delayedContextsCopy = new ArrayList<SpellContext>(delayedContexts);
            for (SpellContext context : delayedContextsCopy) {
                --context.delay;
                if (context.delay > 0) continue;
                delayedContexts.remove(context);
                context.delay = 0;
                context.cspell.safeExecute(context);
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            if (!event.getEntity().isSpectator()) {
                Player player = event.getEntity();
                ItemStack cadStack = PsiAPI.getPlayerCAD(player);
                if (!cadStack.isEmpty() && cadStack.getItem() instanceof ICAD && PsiAPI.canCADBeUpdated(player)) {
                    ((ICAD)cadStack.getItem()).incrementTime(cadStack);
                }
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.tick"));
                PlayerDataHandler.get(player).tick();
            }
        }

        @SubscribeEvent
        public static void onEntityDamage(LivingDamageEvent.Pre event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                PlayerDataHandler.get(player).damage(event.getNewDamage());
                LivingEntity attacker = null;
                if (event.getSource().getEntity() != null && event.getSource().getEntity() instanceof LivingEntity) {
                    attacker = (LivingEntity)event.getSource().getEntity();
                }
                PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.damage", event.getNewDamage(), attacker));
                if (event.getSource().is(DamageTypes.ON_FIRE) || event.getSource().is(DamageTypes.IN_FIRE)) {
                    PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.on_fire"));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerInteractArmorStand(PlayerInteractEvent.EntityInteractSpecific event) {
            Player player = event.getEntity();
            if (!player.isSecondaryUseActive()) {
                return;
            }
            if (!(event.getTarget() instanceof ArmorStand)) {
                return;
            }
            ItemStack itemStackIn = player.getItemInHand(event.getHand());
            ItemStack playerCad = PsiAPI.getPlayerCAD(player);
            if (playerCad != itemStackIn) {
                return;
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                MessageDataSync message = new MessageDataSync(PlayerDataHandler.get(event.getEntity()));
                MessageRegister.sendToPlayer((ServerPlayer)event.getEntity(), message);
            }
        }

        @SubscribeEvent
        public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (event.getEntity().level().isClientSide && !event.getEntity().isSpectator()) {
                    PsiArmorEvent.post(new PsiArmorEvent(player, "psi.event.jump"));
                    MessageRegister.sendToServer(new MessageTriggerJumpSpell());
                }
            }
        }

        @SubscribeEvent
        public static void onPsiArmorEvent(PsiArmorEvent event) {
            if (event.getEntity().isSpectator()) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                Item item;
                ItemStack armor = (ItemStack)event.getEntity().getInventory().armor.get(i);
                if (armor.isEmpty() || !((item = armor.getItem()) instanceof IPsiEventArmor)) continue;
                IPsiEventArmor handler = (IPsiEventArmor)item;
                handler.onEvent(armor, event);
            }
        }

        @SubscribeEvent
        public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            PlayerDataHandler.get((Player)event.getEntity()).eidosChangelog.clear();
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderWorldLast(RenderLevelStageEvent event) {
            Minecraft mc;
            Entity cameraEntity;
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && (cameraEntity = (mc = Minecraft.getInstance()).getCameraEntity()) != null && mc.level != null) {
                float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(false);
                for (Player player : mc.level.players()) {
                    PlayerDataHandler.get(player).render(player, partialTicks, event.getPoseStack());
                }
            }
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onFOVUpdate(ComputeFovModifierEvent event) {
            PlayerData data = PlayerDataHandler.get((Player)Minecraft.getInstance().player);
            if (data.isAnchored) {
                float fov = event.getNewFovModifier();
                fov = data.eidosAnchorTime > 0 ? (fov *= Math.min(5.0f, (float)data.eidosAnchorTime - ClientTickHandler.partialTicks) / 5.0f) : (fov *= (10.0f - Math.min(10.0f, (float)data.postAnchorRecallTime + ClientTickHandler.partialTicks)) / 10.0f);
                event.setNewFovModifier(fov);
            }
        }
    }
}

