/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_client;

import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.network.PEStreamCodecs;
import moze_intel.projecte.network.packets.IPEPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record NovaExplosionSyncPKT(Vec3 explosionCenter, float explosionRadius, Holder<SoundEvent> explosionSound, List<BlockPos> positions) implements IPEPacket
{
    public static final CustomPacketPayload.Type<NovaExplosionSyncPKT> TYPE = new CustomPacketPayload.Type(PECore.rl("nova_explosion"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NovaExplosionSyncPKT> STREAM_CODEC = StreamCodec.composite(PEStreamCodecs.VEC_3, NovaExplosionSyncPKT::explosionCenter, (StreamCodec)ByteBufCodecs.FLOAT, NovaExplosionSyncPKT::explosionRadius, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.SOUND_EVENT), NovaExplosionSyncPKT::explosionSound, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), NovaExplosionSyncPKT::positions, NovaExplosionSyncPKT::new);

    @NotNull
    public CustomPacketPayload.Type<NovaExplosionSyncPKT> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Level level = context.player().level();
        level.playLocalSound(this.explosionCenter.x, this.explosionCenter.y, this.explosionCenter.z, (SoundEvent)this.explosionSound.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f, false);
        for (BlockPos pos : this.positions) {
            Vec3 adjusted = Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)level.random.nextFloat(), (double)level.random.nextFloat(), (double)level.random.nextFloat());
            Vec3 difference = adjusted.subtract(this.explosionCenter);
            double d7 = 0.5 / (difference.length() / (double)this.explosionRadius + 0.1);
            difference = difference.normalize().scale(d7 *= (double)(level.random.nextFloat() * level.random.nextFloat() + 0.3f));
            Vec3 adjustedPoof = adjusted.add(this.explosionCenter).scale(0.5);
            level.addParticle((ParticleOptions)ParticleTypes.POOF, adjustedPoof.x(), adjustedPoof.y(), adjustedPoof.z(), difference.x(), difference.y(), difference.z());
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, adjusted.x(), adjusted.y(), adjusted.z(), difference.x(), difference.y(), difference.z());
        }
    }
}

