/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.recipe_viewer.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Objects;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.integration.recipe_viewer.FuelUpgradeRecipe;
import moze_intel.projecte.integration.recipe_viewer.emi.PEEmiCategory;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CollectorEmiRecipe
implements EmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new PEEmiCategory("collector", PEBlocks.COLLECTOR, PELang.JEI_COLLECTOR);
    private final ResourceLocation recipeId;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final long upgradeEMC;

    public CollectorEmiRecipe(FuelUpgradeRecipe recipe) {
        this.recipeId = recipe.syntheticId();
        this.upgradeEMC = recipe.upgradeEMC();
        this.input = List.of(EmiStack.of((ItemLike)((ItemLike)recipe.input().value())));
        this.output = List.of(EmiStack.of((ItemLike)((ItemLike)recipe.output().value())));
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipeId;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 80;
    }

    public int getDisplayHeight() {
        return 36;
    }

    public void addWidgets(WidgetHolder widgets) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        int y = 9 + 5;
        SlotWidget inputSlot = widgets.addSlot(this.input.getFirst(), 5, y);
        widgets.addSlot((EmiIngredient)this.output.getFirst(), 57, y).recipeContext((EmiRecipe)this);
        MutableComponent emc = PELang.EMC.translate(this.upgradeEMC);
        int stringWidth = fontRenderer.width((FormattedText)emc);
        widgets.addText((Component)emc, (this.getDisplayWidth() - stringWidth) / 2, 3, 0x808080, false);
        widgets.addFillingArrow(5 + inputSlot.getBounds().right(), y, (int)(5L * TimeUtil.MILLISECONDS_PER_SECOND));
    }

    @Nullable
    public RecipeHolder<?> getBackingRecipe() {
        return null;
    }
}

