/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.gameObjs.registries.PEAttachmentTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.impl.codec.PECodecHelper;
import moze_intel.projecte.network.PEStreamCodecs;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncChangePKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncInputsAndLocksPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncPKT;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KnowledgeImpl
implements IKnowledgeProvider {
    private final Player player;

    public static IKnowledgeProvider wrapAttachment(final KnowledgeAttachment attachment) {
        return new KnowledgeImpl(null){

            @Override
            protected KnowledgeAttachment attachment() {
                return attachment;
            }
        };
    }

    public KnowledgeImpl(Player player) {
        this.player = player;
    }

    protected KnowledgeAttachment attachment() {
        Objects.requireNonNull(this.player);
        return (KnowledgeAttachment)this.player.getData(PEAttachmentTypes.KNOWLEDGE);
    }

    protected void fireChangedEvent() {
        if (this.player != null && !this.player.level().isClientSide) {
            NeoForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(this.player));
        }
    }

    @Override
    public boolean hasFullKnowledge() {
        return this.attachment().fullKnowledge;
    }

    @Override
    public void setFullKnowledge(boolean fullKnowledge) {
        KnowledgeAttachment attachment = this.attachment();
        if (attachment.fullKnowledge != fullKnowledge) {
            attachment.fullKnowledge = fullKnowledge;
            this.fireChangedEvent();
        }
    }

    @Override
    public void clearKnowledge() {
        KnowledgeAttachment attachment = this.attachment();
        boolean hasKnowledge = attachment.fullKnowledge || !attachment.knowledge.isEmpty();
        attachment.knowledge.clear();
        attachment.fullKnowledge = false;
        if (hasKnowledge) {
            this.fireChangedEvent();
        }
    }

    @Nullable
    private ItemInfo getIfPersistent(@NotNull ItemInfo info) {
        if (!info.hasModifiedComponents() || EMCMappingHandler.hasEmcValue(info)) {
            return null;
        }
        ItemInfo cleanedInfo = IEMCProxy.INSTANCE.getPersistentInfo(info);
        if (cleanedInfo.hasModifiedComponents() && !EMCMappingHandler.hasEmcValue(cleanedInfo)) {
            return cleanedInfo;
        }
        return null;
    }

    @Override
    public boolean hasKnowledge(@NotNull ItemInfo info) {
        KnowledgeAttachment attachment = this.attachment();
        if (attachment.fullKnowledge) {
            ItemInfo persistentInfo = this.getIfPersistent(info);
            return persistentInfo == null || attachment.knowledge.contains(persistentInfo);
        }
        return attachment.knowledge.contains(IEMCProxy.INSTANCE.getPersistentInfo(info));
    }

    @Override
    public boolean addKnowledge(@NotNull ItemInfo info) {
        KnowledgeAttachment attachment = this.attachment();
        if (attachment.fullKnowledge) {
            ItemInfo persistentInfo = this.getIfPersistent(info);
            if (persistentInfo == null) {
                return false;
            }
            return this.tryAdd(attachment, persistentInfo);
        }
        if (info.getItem().is(PEItems.TOME_OF_KNOWLEDGE.getKey())) {
            info = info.itemOnly();
            attachment.knowledge.add(info);
            attachment.fullKnowledge = true;
            this.fireChangedEvent();
            return true;
        }
        return this.tryAdd(attachment, IEMCProxy.INSTANCE.getPersistentInfo(info));
    }

    private boolean tryAdd(@NotNull KnowledgeAttachment attachment, @NotNull ItemInfo cleanedInfo) {
        if (attachment.knowledge.add(cleanedInfo)) {
            this.fireChangedEvent();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeKnowledge(@NotNull ItemInfo info) {
        KnowledgeAttachment attachment = this.attachment();
        if (attachment.fullKnowledge) {
            if (info.getItem().is(PEItems.TOME_OF_KNOWLEDGE.getKey())) {
                info = info.itemOnly();
                attachment.knowledge.remove(info);
                attachment.fullKnowledge = false;
                this.fireChangedEvent();
                return true;
            }
            ItemInfo persistentInfo = this.getIfPersistent(info);
            return persistentInfo != null && this.tryRemove(attachment, persistentInfo);
        }
        return this.tryRemove(attachment, IEMCProxy.INSTANCE.getPersistentInfo(info));
    }

    private boolean tryRemove(@NotNull KnowledgeAttachment attachment, @NotNull ItemInfo cleanedInfo) {
        if (attachment.knowledge.remove(cleanedInfo)) {
            this.fireChangedEvent();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<ItemInfo> getKnowledge() {
        KnowledgeAttachment attachment = this.attachment();
        if (attachment.fullKnowledge) {
            Set<ItemInfo> allKnowledge = EMCMappingHandler.getMappedItems();
            allKnowledge.addAll(attachment.knowledge);
            return Collections.unmodifiableSet(allKnowledge);
        }
        return Collections.unmodifiableSet(attachment.knowledge);
    }

    @NotNull
    public IItemHandlerModifiable getInputAndLocks() {
        return this.attachment().inputLocks;
    }

    @Override
    public BigInteger getEmc() {
        return this.attachment().emc;
    }

    @Override
    public void setEmc(BigInteger emc) {
        this.attachment().emc = emc;
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new KnowledgeSyncPKT(this.attachment()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncEmc(@NotNull ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new KnowledgeSyncEmcPKT(this.getEmc()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncKnowledgeChange(@NotNull ServerPlayer player, ItemInfo change, boolean learned) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new KnowledgeSyncChangePKT(change, learned), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncInputAndLocks(@NotNull ServerPlayer player, IntList slotsChanged, IKnowledgeProvider.TargetUpdateType updateTargets) {
        if (!slotsChanged.isEmpty()) {
            KnowledgeAttachment attachment = this.attachment();
            int slots = attachment.inputLocks.getSlots();
            Int2ObjectOpenHashMap stacksToSync = new Int2ObjectOpenHashMap();
            IntListIterator intListIterator = slotsChanged.iterator();
            while (intListIterator.hasNext()) {
                int slot = (Integer)intListIterator.next();
                if (slot < 0 || slot >= slots) continue;
                stacksToSync.put(slot, (Object)attachment.inputLocks.getStackInSlot(slot));
            }
            if (!stacksToSync.isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new KnowledgeSyncInputsAndLocksPKT((Int2ObjectMap<ItemStack>)stacksToSync, updateTargets), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public void receiveInputsAndLocks(Int2ObjectMap<ItemStack> changes) {
        KnowledgeAttachment attachment = this.attachment();
        int slots = attachment.inputLocks.getSlots();
        ObjectIterator iterator = Int2ObjectMaps.fastIterator(changes);
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            int slot = entry.getIntKey();
            if (slot < 0 || slot >= slots) continue;
            attachment.inputLocks.setStackInSlot(slot, (ItemStack)entry.getValue());
        }
    }

    public final boolean pruneStaleKnowledge() {
        KnowledgeAttachment attachment = this.attachment();
        ArrayList<ItemInfo> toAdd = new ArrayList<ItemInfo>();
        boolean hasRemoved = false;
        Iterator<ItemInfo> iterator = attachment.knowledge.iterator();
        while (iterator.hasNext()) {
            ItemInfo persistentInfo;
            ItemInfo info = iterator.next();
            if (!info.equals(persistentInfo = IEMCProxy.INSTANCE.getPersistentInfo(info))) {
                if (IEMCProxy.INSTANCE.hasValue(persistentInfo)) {
                    toAdd.add(persistentInfo);
                }
                iterator.remove();
                hasRemoved = true;
                continue;
            }
            if (IEMCProxy.INSTANCE.hasValue(info)) continue;
            iterator.remove();
            hasRemoved = true;
        }
        return attachment.knowledge.addAll(toAdd) || hasRemoved;
    }

    public static class KnowledgeAttachment {
        private static final int LOCK_SLOTS = 9;
        private static final Codec<Set<ItemInfo>> MUTABLE_KNOWLEDGE_CODEC = ItemInfo.CODEC.listOf().promotePartial(error -> PECore.LOGGER.error("Failed to load stored knowledge: {}", error)).xmap(HashSet::new, List::copyOf);
        public static final Codec<KnowledgeAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MUTABLE_KNOWLEDGE_CODEC.fieldOf("knowledge").forGetter(attachment -> attachment.knowledge), (App)PECodecHelper.MUTABLE_HANDLER_CODEC.fieldOf("input_locks").forGetter(attachment -> attachment.inputLocks), (App)IPECodecHelper.INSTANCE.nonNegativeBigInt().optionalFieldOf("emc", (Object)BigInteger.ZERO).forGetter(attachment -> attachment.emc), (App)Codec.BOOL.optionalFieldOf("full_knowledge", (Object)false).forGetter(attachment -> attachment.fullKnowledge)).apply((Applicative)instance, KnowledgeAttachment::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, KnowledgeAttachment> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemInfo.STREAM_CODEC.apply(ByteBufCodecs.collection(HashSet::new)), attachment -> attachment.knowledge, PEStreamCodecs.handlerStreamCodec(9), attachment -> attachment.inputLocks, PEStreamCodecs.EMC_VALUE, attachment -> attachment.emc, (StreamCodec)ByteBufCodecs.BOOL, attachment -> attachment.fullKnowledge, KnowledgeAttachment::new);
        private final ItemStackHandler inputLocks;
        private final Set<ItemInfo> knowledge;
        private boolean fullKnowledge;
        private BigInteger emc;

        public KnowledgeAttachment() {
            this(new HashSet<ItemInfo>(), new ItemStackHandler(9), BigInteger.ZERO, false);
        }

        private KnowledgeAttachment(Set<ItemInfo> knowledge, ItemStackHandler inputLocks, BigInteger emc, boolean fullKnowledge) {
            this.knowledge = knowledge;
            this.inputLocks = inputLocks;
            this.emc = emc;
            this.fullKnowledge = fullKnowledge;
        }

        @Nullable
        public KnowledgeAttachment copy(IAttachmentHolder holder, HolderLookup.Provider registries) {
            return new KnowledgeAttachment(new HashSet<ItemInfo>(this.knowledge), (ItemStackHandler)PEAttachmentTypes.copyHandler((IItemHandler)this.inputLocks, ItemStackHandler::new), this.emc, this.fullKnowledge);
        }
    }
}

