/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PEDamageTypes {
    private static final Map<String, PEDamageType> INTERNAL_DAMAGE_TYPES = new HashMap<String, PEDamageType>();
    public static final Map<String, PEDamageType> DAMAGE_TYPES = Collections.unmodifiableMap(INTERNAL_DAMAGE_TYPES);
    public static final PEDamageType BYPASS_ARMOR_PLAYER_ATTACK = new PEDamageType("player_attack", "player", 0.1f);

    public record PEDamageType(ResourceKey<DamageType> key, String msgId, float exhaustion) implements IHasTranslationKey
    {
        public PEDamageType(ResourceKey<DamageType> key, String msgId, float exhaustion) {
            INTERNAL_DAMAGE_TYPES.put(key.location().toString(), this);
            this.key = key;
            this.msgId = msgId;
            this.exhaustion = exhaustion;
        }

        private PEDamageType(String name, float exhaustion) {
            this(name, "projecte." + name, exhaustion);
        }

        private PEDamageType(String name, String msgId, float exhaustion) {
            this((ResourceKey<DamageType>)ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)PECore.rl(name)), msgId, exhaustion);
        }

        @Override
        @NotNull
        public String getTranslationKey() {
            return "death.attack." + this.msgId();
        }

        public DamageSource source(@NotNull LivingEntity entity) {
            return this.source(entity.level(), entity);
        }

        public DamageSource source(Level level, @Nullable LivingEntity entity) {
            return this.source(level.registryAccess(), entity);
        }

        public DamageSource source(RegistryAccess registryAccess, @Nullable LivingEntity entity) {
            Holder.Reference damageTypeReference = registryAccess.registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(this.key());
            return new DamageSource((Holder)damageTypeReference, (Entity)entity);
        }
    }
}

